/*
 * Decompiled with CFR 0.152.
 */
package uncertain.schema;

import uncertain.composite.QualifiedName;
import uncertain.schema.AbstractCategorized;
import uncertain.schema.IQualifiedNameResolver;
import uncertain.schema.IReference;
import uncertain.schema.ISchemaManager;
import uncertain.schema.ISchemaObject;
import uncertain.schema.IType;
import uncertain.schema.IValidator;
import uncertain.schema.Schema;
import uncertain.schema.SchemaError;

public class Attribute
extends AbstractCategorized
implements IReference {
    boolean mIsRef = false;
    String mRef;
    Attribute mRefAttribute;
    String mType;
    String mUse;
    String mDefault;
    String mDocument;
    IValidator[] mValidators;

    public static Attribute createInstance(String name) {
        QualifiedName qname = new QualifiedName(null, null, name);
        Attribute attrib = new Attribute();
        attrib.setQName(qname);
        return attrib;
    }

    public String getRef() {
        return this.mRef;
    }

    public void setRef(String ref) {
        this.mRef = ref;
        this.mIsRef = this.mRef != null;
    }

    public IValidator[] getValidators() {
        if (this.mIsRef) {
            return this.mRefAttribute.mValidators;
        }
        return this.mValidators;
    }

    public void setValidators(IValidator[] validators) {
        this.mValidators = validators;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public String getUse() {
        return this.mUse;
    }

    public void setUse(String use) {
        this.mUse = use;
    }

    public String getDocument() {
        return this.mDocument;
    }

    public void setDocument(String document) {
        this.mDocument = document;
    }

    public String toString() {
        if (this.mRefAttribute != null) {
            return this.mRefAttribute.toString();
        }
        if (this.mQname == null) {
            return "attribute";
        }
        return this.mQname.toString();
    }

    public boolean isRef() {
        return this.mIsRef;
    }

    public QualifiedName getRefQName() {
        return this.mQname;
    }

    public ISchemaObject getRefObject() {
        return this.getRefAttribute();
    }

    public Attribute getRefAttribute() {
        if (this.mIsRef) {
            return this.mRefAttribute;
        }
        return null;
    }

    public boolean equals(Object another) {
        return this == another;
    }

    public String getDefault() {
        return this.mDefault;
    }

    public void setDefault(String default1) {
        this.mDefault = default1;
    }

    public void resolveReference(ISchemaManager manager) {
        super.resolveReference(manager);
        if (this.mIsRef) {
            Schema schema = this.getSchema();
            QualifiedName qname = schema.getQualifiedName(this.mRef);
            if (qname == null) {
                throw new SchemaError("Can't resolve qualified name:" + this.mRef);
            }
            this.mQname = qname;
            this.mRefAttribute = manager.getAttribute(qname);
            if (this.mRefAttribute == null) {
                throw new SchemaError("Unresolvable attribute ref:" + this.mRef);
            }
        }
    }

    public void resolveQName(IQualifiedNameResolver resolver) {
        super.resolveQName(resolver);
        if (this.mIsRef) {
            this.mQname = resolver.getQualifiedName(this.mRef);
            if (this.mQname == null) {
                throw new SchemaError("Can't resolve ref qualified name:" + this.mRef);
            }
        }
    }

    public IType getAttributeType() {
        Schema schema = this.getSchema();
        QualifiedName qname = null;
        if (this.mType != null) {
            qname = schema.getQualifiedName(this.mType);
        }
        return this.getSchemaManager().getType(qname);
    }

    public QualifiedName getTypeQName() {
        Schema schema = this.getSchema();
        QualifiedName qname = null;
        if (this.mType != null) {
            qname = schema.getQualifiedName(this.mType);
        }
        return qname;
    }
}

