/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.util.LinkedList;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class SetElement
extends AbstractEntry {
    private String target;
    private String name;
    private String namespace;
    private String prefix;
    private int childLevel = 0;

    public void run(ProcedureRunner runner) throws Exception {
        if (this.target == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "target");
        }
        CompositeMap context = runner.getContext();
        Object object = context.getObject(this.target);
        if (object == null) {
            throw BuiltinExceptionFactory.createDataFromXPathIsNull(this, this.target);
        }
        if (!(object instanceof CompositeMap)) {
            throw BuiltinExceptionFactory.createInstanceTypeWrongException(this.target, CompositeMap.class, object.getClass());
        }
        LinkedList result = new LinkedList();
        CompositeUtil.getLevelChilds((CompositeMap)object, this.childLevel, result);
        if (result == null || result.isEmpty()) {
            return;
        }
        for (CompositeMap record : result) {
            if (this.name != null) {
                record.setName(this.name);
            }
            if (this.namespace != null) {
                record.setNameSpaceURI(this.namespace);
            }
            if (this.prefix == null) continue;
            record.setPrefix(this.prefix);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getChildLevel() {
        return this.childLevel;
    }

    public void setChildLevel(int childLevel) {
        this.childLevel = childLevel;
    }
}

