/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class Set
extends AbstractEntry {
    String field;
    String sourceField;
    String value;
    boolean setToNull = false;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String textValue) {
        this.value = textValue;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public void setSourceField(String value) {
        this.sourceField = value;
    }

    public void run(ProcedureRunner runner) {
        if (this.field == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "field");
        }
        CompositeMap context = runner.getContext();
        if (this.setToNull) {
            Object value = context.getObject(this.field);
            if (value != null && value instanceof CompositeMap) {
                ((CompositeMap)value).clear();
            }
            context.putObject(this.field, null, true);
            return;
        }
        if (this.sourceField == null && this.value == null) {
            throw BuiltinExceptionFactory.createOneAttributeMissing(this, "sourceField,value");
        }
        if (this.sourceField != null) {
            context.putObject(this.field, context.getObject(this.sourceField), true);
        } else {
            context.putObject(this.field, (Object)TextParser.parse(this.value, context), true);
        }
    }

    public boolean getSetToNull() {
        return this.setToNull;
    }

    public void setSetToNull(boolean setToNull) {
        this.setToNull = setToNull;
    }
}

