/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import uncertain.proc.ProcedureRunner;

public class ParticipantRegistry {
    HashMap handle_method_map = new HashMap();
    static final ParticipantRegistry default_instance = new ParticipantRegistry();
    static final HandleMethod[] empty_methods = new HandleMethod[0];
    static final String[] method_prefix = new String[]{"pre", "on", "post"};
    static final int[] method_prefix_len = new int[]{3, 2, 4};

    static boolean equalTypes(Class[] a1, Class[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a1.length) {
            if (!a1[i].equals(a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ParticipantRegistry defaultInstance() {
        return default_instance;
    }

    private HandleMethod getHandleMethod(Method m) {
        Class<?> return_type = m.getReturnType();
        if (!Void.TYPE.equals(return_type) && !Integer.TYPE.equals(return_type)) {
            return null;
        }
        int arg_type = 0;
        Class<?>[] params = m.getParameterTypes();
        arg_type = params.length == 0 ? 0 : (params.length == 1 ? (ProcedureRunner.class.equals(params[0]) ? 1 : 2) : 2);
        String name = m.getName();
        int i = 0;
        while (i < method_prefix.length) {
            if (name.length() > method_prefix_len[i] && name.indexOf(method_prefix[i]) == 0 && !Character.isLowerCase(name.charAt(method_prefix_len[i]))) {
                return new HandleMethod(i, m, arg_type, name.substring(method_prefix_len[i]).toLowerCase());
            }
            ++i;
        }
        return null;
    }

    HandleMethod[] createHandleMethods(Class cls) {
        LinkedList<HandleMethod> lst = new LinkedList<HandleMethod>();
        Method[] methods = cls.getMethods();
        int i = 0;
        while (i < methods.length) {
            HandleMethod h = this.getHandleMethod(methods[i]);
            if (h != null) {
                lst.add(h);
            }
            ++i;
        }
        if (lst.size() == 0) {
            return empty_methods;
        }
        Object[] handles = lst.toArray();
        HandleMethod[] hmarray = new HandleMethod[handles.length];
        System.arraycopy(handles, 0, hmarray, 0, handles.length);
        this.handle_method_map.put(cls, hmarray);
        return hmarray;
    }

    public HandleMethod[] getHandleMethods(Class cls) {
        HandleMethod[] m = (HandleMethod[])this.handle_method_map.get(cls);
        if (m == null) {
            m = this.createHandleMethods(cls);
        }
        return m;
    }

    public boolean isParticipant(Class cls) {
        HandleMethod[] m = this.getHandleMethods(cls);
        return m != empty_methods;
    }

    public int getEntrySize() {
        return this.handle_method_map.size();
    }

    public class HandleMethod {
        public int sequence;
        public Method method;
        public String event_name;
        public int arg_type;

        public HandleMethod(int sequence, Method method, int arg_type, String event_name) {
            if (method == null) {
                throw new IllegalArgumentException("method must not be null");
            }
            this.sequence = sequence;
            this.method = method;
            this.event_name = event_name;
            this.arg_type = arg_type;
        }

        public boolean equals(Object another) {
            if (another == null) {
                return false;
            }
            if (another instanceof HandleMethod) {
                HandleMethod m = (HandleMethod)another;
                return this.sequence == m.sequence && this.method.equals(m.method) && this.event_name.equalsIgnoreCase(m.event_name) && this.arg_type == m.arg_type;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(method_prefix[this.sequence]) + '.' + this.event_name + " " + this.method.toString() + " " + this.arg_type;
        }
    }
}

