/*
 * Decompiled with CFR 0.152.
 */
package uncertain.logging;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import uncertain.logging.AbstractLoggerProvider;
import uncertain.logging.DummyLogger;
import uncertain.logging.ILogger;
import uncertain.logging.ILoggerProvider;
import uncertain.logging.ILoggerProviderGroup;
import uncertain.logging.LoggerList;

public class LoggerProviderGroup
extends AbstractLoggerProvider
implements ILoggerProviderGroup {
    Set mProviderSet = new HashSet();
    String mName;

    public void addLoggerProvider(ILoggerProvider provider) {
        this.mProviderSet.add(provider);
    }

    public ILogger getLogger(String topic) {
        LoggerList logger_group = null;
        for (ILoggerProvider provider : this.mProviderSet) {
            ILogger logger = provider.getLogger(topic);
            if (logger == null || logger == DummyLogger.DEFAULT_LOGGER) continue;
            if (logger_group == null) {
                logger_group = new LoggerList();
            }
            logger_group.addLogger(logger);
        }
        if (logger_group == null) {
            return DummyLogger.DEFAULT_LOGGER;
        }
        if (logger_group.size() == 1) {
            return logger_group.getFirst();
        }
        return logger_group;
    }

    public Collection getLoggerProviders() {
        return this.mProviderSet;
    }
}

