/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite.transform;

import java.util.Iterator;
import uncertain.composite.CompositeMap;

public class GroupConfig {
    public static final String KEY_GROUP_KEY_FIELDS = "group_key_fields";
    public static final String KEY_GROUP_ATTRIBUTES = "group_attributes";
    public static final String KEY_RECORD_NAME = "record_name";
    public static final String SPLIT = ",";
    String[] group_key_fields;
    String[] group_attribs;
    String record_name;
    boolean extendParentAttributes = true;

    public GroupConfig(String[] groupKeyFields, String[] groupAttribs, String recordName, boolean extendParentAttributes) {
        this.group_key_fields = groupKeyFields;
        this.group_attribs = groupAttribs;
        this.record_name = this.createRecordName(recordName);
        this.extendParentAttributes = extendParentAttributes;
    }

    public GroupConfig(String[] groupKeyFields, String[] groupAttribs, String recordName) {
        this.group_key_fields = groupKeyFields;
        this.group_attribs = groupAttribs;
        this.record_name = this.createRecordName(recordName);
    }

    public GroupConfig(String[] groupKeyFields, String recordName) {
        this.group_key_fields = groupKeyFields;
        this.record_name = this.createRecordName(recordName);
    }

    public GroupConfig(String[] groupKeyFields, String[] groupAttribs) {
        this.group_key_fields = groupKeyFields;
        this.group_attribs = groupAttribs;
        this.record_name = this.createRecordName(null);
    }

    public GroupConfig(String[] groupKeyFields) {
        this.group_key_fields = groupKeyFields;
        this.record_name = this.createRecordName(null);
    }

    public String[] getGroupKeyFields() {
        return this.group_key_fields;
    }

    public void setGroupKeyFiedls(String[] groupKeyFields) {
        this.group_key_fields = groupKeyFields;
    }

    public String[] getGroupAttributes() {
        return this.group_attribs;
    }

    public void setGroupAttributes(String[] groupAttributes) {
        this.group_attribs = groupAttributes;
    }

    public void setRecordName(String recordName) {
        this.record_name = recordName;
    }

    public String getRecordName() {
        return this.record_name;
    }

    public static GroupConfig[] createGroupConfigs(CompositeMap source) {
        if (source == null || source.getChildIterator() == null) {
            return null;
        }
        int level = 0;
        GroupConfig[] gourpConfig = new GroupConfig[source.getChilds().size()];
        Iterator it = source.getChildIterator();
        while (it.hasNext()) {
            CompositeMap record = (CompositeMap)it.next();
            String groupValue = record.getString(KEY_GROUP_KEY_FIELDS);
            if (groupValue != null) {
                String groupAttribValue = record.getString(KEY_GROUP_ATTRIBUTES);
                String[] attributes = null;
                if (groupAttribValue != null) {
                    attributes = groupAttribValue.split(SPLIT);
                }
                gourpConfig[level] = level != 0 ? new GroupConfig(groupValue.split(SPLIT), attributes, record.getString(KEY_RECORD_NAME)) : new GroupConfig(groupValue.split(SPLIT), attributes, record.getString(KEY_RECORD_NAME), false);
            }
            ++level;
        }
        return gourpConfig;
    }

    protected String createRecordName(String recordName) {
        if (recordName != null) {
            return recordName;
        }
        StringBuffer bf = new StringBuffer("group");
        int i = 0;
        while (i < this.group_key_fields.length) {
            bf.append("_").append(this.group_key_fields[i]);
            ++i;
        }
        return bf.toString();
    }

    public boolean isExtendParentAttributes() {
        return this.extendParentAttributes;
    }

    public void setExtendParentAttributes(boolean extendParentAttributes) {
        this.extendParentAttributes = extendParentAttributes;
    }
}

