/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import uncertain.composite.CompositeAccessor;
import uncertain.composite.IterationHandle;
import uncertain.composite.QualifiedName;
import uncertain.composite.TextParser;
import uncertain.composite.TypedHashMap;
import uncertain.composite.XMLOutputter;
import uncertain.util.resource.ILocatable;
import uncertain.util.resource.Location;

public class CompositeMap
extends TypedHashMap
implements Cloneable {
    public static final int DEFAULT_HASHMAP_SIZE = 30;
    protected String name;
    protected String prefix;
    protected String namespace_uri;
    protected String text;
    protected CompositeMap parent;
    protected List childs;
    protected File source;
    protected Map namespace_mapping;
    Location location;

    public CompositeMap() {
        super(30);
    }

    public CompositeMap(String _name) {
        super(30);
        this.setName(_name);
    }

    public CompositeMap(String _prefix, String _uri, String _name) {
        super(30);
        this.setName(_name);
        this.setPrefix(_prefix);
        this.setNameSpaceURI(_uri);
    }

    public CompositeMap(int size) {
        super(size);
    }

    public CompositeMap(int size, float load_factor) {
        super(size, load_factor);
    }

    public CompositeMap(CompositeMap another) {
        this(another.prefix, another.namespace_uri, another.name);
        this.copy(another);
    }

    public CompositeMap(String name, Map map) {
        this.setName(name);
        this.putAll(map);
    }

    public void addChilds(Collection another) {
        if (another == null) {
            return;
        }
        for (Object obj : another) {
            if (!(obj instanceof CompositeMap)) continue;
            CompositeMap child = new CompositeMap((CompositeMap)obj);
            this.addChild(child);
        }
    }

    /*
     * Unable to fully structure code
     */
    public CompositeMap replaceChild(CompositeMap child, CompositeMap new_child) {
        if (child == null) {
            return null;
        }
        it = (ListIterator)this.getChildIterator();
        if (it != null) ** GOTO lbl14
        return null;
lbl-1000:
        // 1 sources

        {
            m = (CompositeMap)it.next();
            if (m != child) continue;
            if (new_child == null) {
                it.remove();
                return null;
            }
            new_child.setParent(this);
            it.set(new_child);
            return new_child;
lbl14:
            // 2 sources

            ** while (it.hasNext())
        }
lbl15:
        // 1 sources

        return null;
    }

    public CompositeMap replaceChild(String child_name, CompositeMap new_child) {
        return this.replaceChild(this.getChild(child_name), new_child);
    }

    public CompositeMap copy(CompositeMap another) {
        this.putAll(another);
        this.addChilds(another.childs);
        this.text = another.text;
        this.source = another.source;
        this.location = another.location;
        return this;
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public void setNameSpaceURI(String _uri) {
        if (_uri != null && _uri.length() == 0) {
            _uri = null;
        }
        this.namespace_uri = _uri;
    }

    public void setPrefix(String _p) {
        if (_p != null && _p.length() == 0) {
            _p = null;
        }
        this.prefix = _p;
    }

    public void setNameSpace(String _prefix, String _uri) {
        this.setPrefix(_prefix);
        this.setNameSpaceURI(_uri);
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespaceURI() {
        return this.namespace_uri;
    }

    public String getRawName() {
        if (this.prefix == null) {
            return this.name;
        }
        return String.valueOf(this.prefix) + ':' + this.name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String t) {
        this.text = t;
    }

    public void setParent(CompositeMap p) {
        this.parent = p;
    }

    public CompositeMap getParent() {
        return this.parent;
    }

    public CompositeMap getRoot() {
        CompositeMap map = this.parent;
        while (map != null) {
            if (map.getParent() == null) {
                return map;
            }
            map = map.getParent();
        }
        return this;
    }

    public Object put(Object key, Object value) {
        if (value != null && value instanceof CompositeMap) {
            ((CompositeMap)value).setParent(this);
        }
        return super.put(key, value);
    }

    public Object putObject(String key, Object value, char attribute_char) {
        if (key == null) {
            return null;
        }
        if (key.charAt(0) == attribute_char) {
            return this.put(key.substring(1), value);
        }
        if (value instanceof CompositeMap && value != null) {
            CompositeMap cmap = (CompositeMap)value;
            cmap.setName(key);
            this.addChild(cmap);
            return value;
        }
        return null;
    }

    public Object putObject(String key, Object value) {
        return this.putObject(key, value, '@');
    }

    Object getObject(String key, char attribute_char) {
        if (key == null) {
            return null;
        }
        if (key.charAt(0) == attribute_char) {
            return this.get(key.substring(1));
        }
        return this.getChild(key);
    }

    public void addChild(int index, CompositeMap child) {
        child.parent = this;
        this.getChildsNotNull().add(index, child);
    }

    public void addChild(CompositeMap child) {
        child.parent = this;
        this.getChildsNotNull().add(child);
    }

    public boolean removeChild(CompositeMap child) {
        boolean removed = false;
        if (this.childs != null) {
            ListIterator it = this.childs.listIterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj != child) continue;
                it.remove();
                removed = true;
                break;
            }
            if (removed) {
                child.setParent(null);
            }
        }
        return removed;
    }

    public CompositeMap createChild(String prefix, String uri, String name) {
        CompositeMap child = new CompositeMap(prefix, uri, name);
        this.addChild(child);
        return child;
    }

    public CompositeMap createChild(String name) {
        return this.createChild(null, null, name);
    }

    public CompositeMap createChildByTag(String access_tag) {
        return CompositeAccessor.defaultInstance().createChild(this, access_tag);
    }

    public CompositeMap getChild(CompositeMap child) {
        if (this.childs == null) {
            return null;
        }
        for (CompositeMap node : this.childs) {
            if (!node.equals(child)) continue;
            return node;
        }
        return null;
    }

    public CompositeMap getChild(String name) {
        if (this.childs == null) {
            return null;
        }
        for (CompositeMap node : this.childs) {
            String nm = node.getName();
            if (nm == null || !nm.equals(name)) continue;
            return node;
        }
        return null;
    }

    public CompositeMap getChildByAttrib(Object attrib_key, Object attrib_value) {
        return this.getChildByAttrib(null, attrib_key, attrib_value);
    }

    /*
     * Unable to fully structure code
     */
    public CompositeMap getChildByAttrib(String element_name, Object attrib_key, Object attrib_value) {
        if (attrib_key == null) {
            return null;
        }
        it = this.getChildIterator();
        if (it != null) ** GOTO lbl9
        return null;
lbl-1000:
        // 1 sources

        {
            item = (CompositeMap)it.next();
            if (element_name != null && !element_name.equals(item.getName()) || !((vl = item.get(attrib_key)) == null ? attrib_value == null : vl.equals(attrib_value) != false)) continue;
            return item;
lbl9:
            // 2 sources

            ** while (it.hasNext())
        }
lbl10:
        // 1 sources

        return null;
    }

    public List getChilds() {
        return this.childs;
    }

    public List getChildsNotNull() {
        if (this.childs == null) {
            this.childs = new LinkedList();
        }
        return this.childs;
    }

    public Iterator getChildIterator() {
        if (this.childs == null) {
            return null;
        }
        return this.childs.iterator();
    }

    public Object getObject(String key) {
        return CompositeAccessor.defaultInstance().get(this, key);
    }

    public boolean putObject(String key, Object value, boolean create) {
        return CompositeAccessor.defaultInstance().put(this, key, value, create);
    }

    public String getParameter(String key, boolean parse_param) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            if (parse_param) {
                return TextParser.parse((String)obj, this);
            }
            return (String)obj;
        }
        return obj.toString();
    }

    public String toXML() {
        return XMLOutputter.defaultInstance().toXML(this);
    }

    int iterateChild(IterationHandle handle, boolean root_first) {
        int result = 0;
        if (this.childs == null) {
            return result;
        }
        ListIterator it = this.childs.listIterator();
        while (it.hasNext()) {
            CompositeMap child = (CompositeMap)it.next();
            result = child.iterate(handle, root_first);
            if (result == 2) {
                return result;
            }
            if (result != -1) continue;
            it.remove();
            result = 0;
        }
        return result;
    }

    public int iterate(IterationHandle handle, boolean root_first) {
        if (root_first) {
            int result = handle.process(this);
            if (result == 0) {
                result = this.iterateChild(handle, root_first);
            }
            return result;
        }
        int result = this.iterateChild(handle, root_first);
        if (result != 2) {
            handle.process(this);
        }
        return result;
    }

    public void clear() {
        super.clear();
        if (this.childs != null) {
            this.childs.clear();
        }
        this.name = null;
        this.text = null;
        this.namespace_uri = null;
        this.prefix = null;
        this.childs = null;
        this.parent = null;
        this.source = null;
    }

    public QualifiedName getQName() {
        return new QualifiedName(this.namespace_uri, this.name);
    }

    public Object clone() {
        CompositeMap m = (CompositeMap)super.clone();
        if (this.childs != null) {
            m.childs = new LinkedList();
            for (CompositeMap child : this.childs) {
                CompositeMap new_child = (CompositeMap)child.clone();
                new_child.setParent(m);
                m.childs.add(new_child);
            }
        }
        return m;
    }

    public File getSourceFile() {
        if (this.source != null) {
            return this.source;
        }
        if (this.parent != null) {
            return this.parent.getSourceFile();
        }
        return null;
    }

    public void setSourceFile(File source) {
        this.source = source;
    }

    public Map getNamespaceMapping() {
        return this.namespace_mapping;
    }

    public void setNamespaceMapping(Map mapping) {
        this.namespace_mapping = mapping;
    }

    public Location getLocationNotNull() {
        if (this.location == null) {
            this.location = new Location();
        }
        return this.location;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public ILocatable asLocatable() {
        return new ILocatable(){

            public String getOriginSource() {
                File source = CompositeMap.this.getSourceFile();
                return source == null ? null : source.getAbsolutePath();
            }

            public Location getOriginLocation() {
                return CompositeMap.this.location;
            }
        };
    }
}

