/*
 * Decompiled with CFR 0.152.
 */
package uncertain.cache;

import java.util.HashMap;
import java.util.Map;
import uncertain.cache.CacheMapping;
import uncertain.cache.CacheWrapper;
import uncertain.cache.ICache;
import uncertain.cache.ICacheFactory;
import uncertain.cache.ICacheReader;
import uncertain.cache.ICacheWriter;
import uncertain.cache.INamedCacheFactory;
import uncertain.core.ConfigurationError;
import uncertain.core.ILifeCycle;
import uncertain.ocm.IObjectRegistry;

public class CacheFactoryConfig
implements INamedCacheFactory,
ILifeCycle {
    private static final CacheWrapper NOT_ENABLED_CACHE = new CacheWrapper();
    String mName;
    INamedCacheFactory mDefaultCacheFactory;
    String mDefaultCacheFactoryName;
    INamedCacheFactory[] mNamedCacheFactoryArray;
    CacheMapping[] mCacheMappingArray;
    Map mCacheFactoryMap = new HashMap();
    Map mPredefinedCacheMap = new HashMap();

    public static ICache getNamedCache(IObjectRegistry reg, String name) {
        INamedCacheFactory fact = (INamedCacheFactory)reg.getInstanceOfType(INamedCacheFactory.class);
        if (fact != null) {
            if (!fact.isCacheEnabled(name)) {
                return null;
            }
            return fact.getNamedCache(name);
        }
        return null;
    }

    public CacheFactoryConfig() {
    }

    public CacheFactoryConfig(IObjectRegistry reg) {
        reg.registerInstance(INamedCacheFactory.class, this);
        reg.registerInstance(ICacheFactory.class, this);
    }

    public String getDefaultCacheFactory() {
        return this.mDefaultCacheFactoryName;
    }

    public void setDefaultCacheFactory(String mDefaultCacheFactory) {
        this.mDefaultCacheFactoryName = mDefaultCacheFactory;
    }

    public ICacheReader getCacheReader() {
        return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getCacheReader();
    }

    public ICacheWriter getCacheWriter() {
        return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getCacheWriter();
    }

    public ICache getCache() {
        return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getCache();
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public ICache getNamedCache(String name) {
        Object o = this.mPredefinedCacheMap.get(name);
        if (o == null) {
            return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getNamedCache(name);
        }
        if (NOT_ENABLED_CACHE.equals(o)) {
            return null;
        }
        return ((INamedCacheFactory)o).getNamedCache(name);
    }

    public void addCacheFactories(INamedCacheFactory[] factories) {
        this.mNamedCacheFactoryArray = factories;
    }

    public void addCacheMappings(CacheMapping[] mappings) {
        this.mCacheMappingArray = mappings;
    }

    public boolean startup() {
        int i = 0;
        while (i < this.mNamedCacheFactoryArray.length) {
            this.mCacheFactoryMap.put(this.mNamedCacheFactoryArray[i].getName(), this.mNamedCacheFactoryArray[i]);
            ++i;
        }
        i = 0;
        while (i < this.mCacheMappingArray.length) {
            CacheMapping cm = this.mCacheMappingArray[i];
            INamedCacheFactory fact = (INamedCacheFactory)this.mCacheFactoryMap.get(cm.getCacheFactory());
            if (fact == null) {
                throw new ConfigurationError("Can't find cache factory named " + cm.getCacheFactory());
            }
            if (!cm.getEnabled()) {
                this.mPredefinedCacheMap.put(cm.getName(), NOT_ENABLED_CACHE);
            } else {
                this.mPredefinedCacheMap.put(cm.getName(), fact);
            }
            ++i;
        }
        if (this.mDefaultCacheFactoryName != null) {
            this.mDefaultCacheFactory = (INamedCacheFactory)this.mCacheFactoryMap.get(this.mDefaultCacheFactoryName);
            if (this.mDefaultCacheFactory == null) {
                throw new ConfigurationError("Can't find cache factory named " + this.mDefaultCacheFactoryName);
            }
        }
        return true;
    }

    public boolean isCacheEnabled(String name) {
        Object o = this.mPredefinedCacheMap.get(name);
        if (o == null) {
            return this.mDefaultCacheFactory == null ? false : this.mDefaultCacheFactory.isCacheEnabled(name);
        }
        return !NOT_ENABLED_CACHE.equals(o);
    }

    public void shutdown() {
        if (this.mNamedCacheFactoryArray == null) {
            return;
        }
        int i = 0;
        while (i < this.mNamedCacheFactoryArray.length) {
            INamedCacheFactory o = this.mNamedCacheFactoryArray[i];
            if (o instanceof ILifeCycle) {
                ILifeCycle s = (ILifeCycle)((Object)o);
                s.shutdown();
            }
            ++i;
        }
    }
}

