/*
 * Decompiled with CFR 0.152.
 */
package aurora.transaction;

import aurora.database.service.SqlServiceContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;

public class UserTransactionImpl
implements UserTransaction {
    SqlServiceContext context;
    ILogger logger;

    public void setContext(CompositeMap map) {
        this.context = SqlServiceContext.createSqlServiceContext(map);
        this.logger = LoggingContext.getLogger(map, "aurora.database");
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Set conn_set = this.context.getAllConnection();
        if (conn_set == null) {
            return;
        }
        for (Connection conn : conn_set) {
            try {
                conn.commit();
            }
            catch (SQLException ex) {
                this.logger.severe("Error when commit connection:" + ex.getMessage());
            }
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Set conn_set = this.context.getAllConnection();
        if (conn_set == null) {
            return;
        }
        for (Connection conn : conn_set) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                this.logger.severe("Error when rollback connection:" + ex.getMessage());
            }
        }
    }

    public int getStatus() throws SystemException {
        return 0;
    }

    public void begin() throws NotSupportedException, SystemException {
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
    }

    public void setTransactionTimeout(int arg0) throws SystemException {
    }
}

