/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.json;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;

public class JSONPrintWriter
extends PrintWriter {
    public JSONPrintWriter(Writer out) {
        super(out);
    }

    public void printInternal(char c) throws IOException {
        switch (c) {
            case '\"': 
            case '\\': {
                this.out.write(92);
                this.out.write(c);
                break;
            }
            case '/': {
                this.out.write(92);
                this.out.write(c);
                break;
            }
            case '\b': {
                this.out.write("\\b");
                break;
            }
            case '\t': {
                this.out.write("\\t");
                break;
            }
            case '\n': {
                this.out.write("\\n");
                break;
            }
            case '\f': {
                this.out.write("\\f");
                break;
            }
            case '\r': {
                this.out.write("\\r");
                break;
            }
            default: {
                if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                    String t = "000" + Integer.toHexString(c);
                    this.out.write("\\u" + t.substring(t.length() - 4));
                    break;
                }
                this.out.write(c);
            }
        }
    }

    public void printInternal(String string) throws IOException {
        if (string == null) {
            return;
        }
        char c = '\u0000';
        int len = string.length();
        this.out.write(34);
        int i = 0;
        while (i < len) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    this.out.write(92);
                    this.out.write(c);
                    break;
                }
                case '/': {
                    if (b == '<') {
                        this.out.write(92);
                    }
                    this.out.write(c);
                    break;
                }
                case '\b': {
                    this.out.write("\\b");
                    break;
                }
                case '\t': {
                    this.out.write("\\t");
                    break;
                }
                case '\n': {
                    this.out.write("\\n");
                    break;
                }
                case '\f': {
                    this.out.write("\\f");
                    break;
                }
                case '\r': {
                    this.out.write("\\r");
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        this.out.write("\\u" + t.substring(t.length() - 4));
                        break;
                    }
                    this.out.write(c);
                }
            }
            ++i;
        }
        this.out.write(34);
    }

    private void myEnsureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.myEnsureOpen();
                this.out.write(c);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int off, int len) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.myEnsureOpen();
                String s = new String(buf, off, len);
                this.printInternal(s);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.myEnsureOpen();
                this.printInternal(new String(buf));
            }
        }
        catch (IOException x) {
            this.setError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.myEnsureOpen();
                String str = new String(s.substring(off, off + len));
                this.printInternal(str);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
    }
}

