/*
 * Decompiled with CFR 0.152.
 */
package aurora.service;

import aurora.database.service.SqlServiceContext;
import aurora.service.IService;
import aurora.service.IServiceFactory;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.transaction.ITransactionService;
import aurora.transaction.UserTransactionImpl;
import java.sql.SQLException;
import javax.transaction.UserTransaction;
import uncertain.composite.CompositeMap;
import uncertain.core.IContainer;
import uncertain.event.Configuration;
import uncertain.proc.IProcedureManager;

public class ServiceFactoryImpl
implements IServiceFactory {
    IContainer mContainer;
    ITransactionService mTransactionService;
    IProcedureManager mProcedureManager;
    ThreadLocal mTransactionLocal = new ThreadLocal();

    public ServiceFactoryImpl(IContainer container, ITransactionService ts, IProcedureManager pm) {
        this.mContainer = container;
        this.mTransactionService = ts;
        this.mProcedureManager = pm;
    }

    public IService createService(CompositeMap context) {
        return this.createService(null, context);
    }

    public IService createService(String service_name, CompositeMap context) {
        ServiceInstance inst = new ServiceInstance(service_name, this.mProcedureManager);
        inst.setContextMap(context);
        inst.setName(service_name);
        Configuration config = (Configuration)this.mContainer.getEventDispatcher();
        if (config != null) {
            inst.setRootConfig(config);
        }
        return inst;
    }

    public void beginService(CompositeMap context) {
        UserTransaction trans = this.mTransactionService.getUserTransaction();
        try {
            trans.begin();
            if (trans instanceof UserTransactionImpl) {
                ((UserTransactionImpl)trans).setContext(context);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.mTransactionLocal.set(trans);
    }

    public void finishService(CompositeMap context) {
        try {
            try {
                ServiceContext ctx = ServiceContext.createServiceContext(context);
                UserTransaction trans = (UserTransaction)this.mTransactionLocal.get();
                if (trans != null) {
                    if (ctx.isSuccess()) {
                        trans.commit();
                    } else {
                        trans.rollback();
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.mTransactionLocal.remove();
            SqlServiceContext ctx = SqlServiceContext.createSqlServiceContext(context);
            try {
                ctx.freeConnection();
            }
            catch (SQLException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }
}

