/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.component.std.config.ComponentConfig;
import java.util.List;
import uncertain.composite.CompositeMap;

public class GridColumnConfig
extends ComponentConfig {
    public static final String TAG_NAME = "column";
    public static final String PROPERTITY_EDITOR = "editor";
    public static final String PROPERTITY_ALIGN = "align";
    public static final String PROPERTITY_LOCK = "lock";
    public static final String PROPERTITY_HIDDEN = "hidden";
    public static final String PROPERTITY_RESIZABLE = "resizable";
    public static final String PROPERTITY_RENDERER = "renderer";
    public static final String PROPERTITY_FOOTER_RENDERER = "footerrenderer";
    public static final String PROPERTITY_SORTABLE = "sortable";
    public static final String PROPERTITY_SORTABLE_FIELD = "sortfield";
    public static final String PROPERTITY_FOR_EXPORT = "forexport";
    public static final String PROPERTITY_EXPORT_FIELD = "exportfield";
    public static final String PROPERTITY_EDITOR_FUNCTION = "editorfunction";
    private static final String DEFAULT_ALIGN = "left";

    public static GridColumnConfig getInstance() {
        GridColumnConfig model = new GridColumnConfig();
        model.initialize(GridColumnConfig.createContext(null, TAG_NAME));
        model.removeMapping();
        return model;
    }

    public static GridColumnConfig getInstance(CompositeMap context) {
        GridColumnConfig model = new GridColumnConfig();
        model.initialize(GridColumnConfig.createContext(context, TAG_NAME));
        model.removeMapping();
        return model;
    }

    private void removeMapping() {
        List childs = this.object_context.getChilds();
        if (childs != null) {
            Object[] array = childs.toArray();
            int i = 0;
            while (i < array.length) {
                CompositeMap map = (CompositeMap)array[i];
                this.object_context.removeChild(map);
                ++i;
            }
        }
    }

    public boolean isLock() {
        return this.getBoolean(PROPERTITY_LOCK, false);
    }

    public void setLock(boolean lock) {
        this.putBoolean(PROPERTITY_LOCK, lock);
    }

    public boolean isHidden() {
        return this.getBoolean(PROPERTITY_HIDDEN, false);
    }

    public void setHidden(boolean hidden) {
        this.putBoolean(PROPERTITY_HIDDEN, hidden);
    }

    public String getAlign() {
        return this.getString(PROPERTITY_ALIGN, DEFAULT_ALIGN);
    }

    public void setAlign(String align) {
        this.putString(PROPERTITY_ALIGN, align);
    }

    public boolean isSortable() {
        return this.getBoolean(PROPERTITY_SORTABLE, true);
    }

    public void setSortable(boolean sortable) {
        this.putBoolean(PROPERTITY_SORTABLE, sortable);
    }

    public String getSortField() {
        return this.getString(PROPERTITY_SORTABLE_FIELD);
    }

    public void setSortField(String field) {
        this.putString(PROPERTITY_SORTABLE_FIELD, field);
    }

    public String getExportField() {
        return this.getString(PROPERTITY_EXPORT_FIELD);
    }

    public void setExportField(String field) {
        this.putString(PROPERTITY_EXPORT_FIELD, field);
    }

    public boolean isForExport() {
        return this.getBoolean(PROPERTITY_FOR_EXPORT, true);
    }

    public void setForExport(boolean forExport) {
        this.putBoolean(PROPERTITY_FOR_EXPORT, forExport);
    }

    public boolean isResizable() {
        return this.getBoolean(PROPERTITY_RESIZABLE, true);
    }

    public void setResizable(boolean resiable) {
        this.putBoolean(PROPERTITY_RESIZABLE, resiable);
    }

    public String getPrompt() {
        return this.getString("prompt");
    }

    public void setPrompt(String prompt) {
        this.putString("prompt", prompt);
    }

    public String getFooterRenderer() {
        return this.getString(PROPERTITY_FOOTER_RENDERER);
    }

    public void setFooterRenderer(String renderer) {
        this.putString(PROPERTITY_FOOTER_RENDERER, renderer);
    }

    public String getRenderer() {
        return this.getString(PROPERTITY_RENDERER, "");
    }

    public void setRenderer(String renderer) {
        this.putString(PROPERTITY_RENDERER, renderer);
    }

    public String getEditor() {
        return this.getString(PROPERTITY_EDITOR);
    }

    public void setEditor(String editor) {
        this.putString(PROPERTITY_EDITOR, editor);
    }

    public String getEditorFunction() {
        return this.getString(PROPERTITY_EDITOR_FUNCTION);
    }

    public void setEditorFunction(String func) {
        this.putString(PROPERTITY_EDITOR_FUNCTION, func);
    }
}

