/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.ViewPartConfigError;
import aurora.presentation.component.ViewPartTag;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.util.template.EmptyTag;
import uncertain.util.template.ITagContent;
import uncertain.util.template.ITagCreator;

public class ViewPartTagCreator
implements ITagCreator {
    static final EmptyTag EMPTY_TAG = new EmptyTag();
    Collection mChilds;
    Map mContentMap;
    BuildSession mBuildSession;
    ViewContext mViewContext;
    String mIndexField;

    public ViewPartTagCreator(BuildSession session, ViewContext context, String indexField) {
        this.mIndexField = indexField;
        this.mBuildSession = session;
        this.mViewContext = context;
        CompositeMap view = this.mViewContext.getView();
        if (view == null) {
            throw new RuntimeException("No view in ViewContext");
        }
        this.addChilds(view.getChilds());
    }

    public void clear() {
        if (this.mContentMap != null) {
            this.mContentMap.clear();
            this.mContentMap = null;
        }
        this.mChilds = null;
    }

    public void addChilds(Collection childs) {
        this.clear();
        if (childs == null) {
            return;
        }
        this.mContentMap = new HashMap();
        this.mChilds = childs;
        for (CompositeMap item : this.mChilds) {
            String name = item.getString(this.mIndexField);
            if (name == null) {
                throw new ViewPartConfigError("view part doesn't has 'name' property:" + item.toXML());
            }
            if (this.mContentMap.containsKey(name)) {
                throw new ViewPartConfigError("view part with name '" + name + "' already defined");
            }
            this.mContentMap.put(name, item);
        }
    }

    public ITagContent createInstance(String name_space, String tag) {
        if (this.mContentMap == null) {
            return EMPTY_TAG;
        }
        CompositeMap view = (CompositeMap)this.mContentMap.get(tag);
        if (view == null) {
            return EMPTY_TAG;
        }
        return new ViewPartTag(this.mBuildSession, this.mViewContext, view);
    }

    public String getIndexField() {
        return this.mIndexField;
    }

    public void setIndexField(String indexField) {
        this.mIndexField = indexField;
    }
}

