/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql.builder;

import aurora.database.sql.ConditionList;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.StringConcatenater;
import aurora.database.sql.UpdateField;
import aurora.database.sql.UpdateStatement;
import aurora.database.sql.UpdateTarget;
import aurora.database.sql.builder.AbstractSqlBuilder;
import java.util.List;

public class DefaultUpdateBuilder
extends AbstractSqlBuilder {
    public String createSql(UpdateField field) {
        return field.getNameForOperate();
    }

    public String createSql(UpdateTarget target) {
        StringBuffer sql = new StringBuffer();
        sql.append(target.getTableName());
        String alias = target.getAlias();
        if (alias != null) {
            sql.append(" ").append(alias);
        }
        return sql.toString();
    }

    public String createUpdateList(List fields) {
        StringConcatenater sc = new StringConcatenater();
        for (UpdateField field : fields) {
            StringBuffer exp = new StringBuffer();
            exp.append(field.getNameForOperate());
            exp.append("=");
            exp.append(this.mRegistry.getSql(field.getUpdateSource()));
            sc.append(exp.toString());
        }
        return sc.getContent();
    }

    public String createWherePart(UpdateStatement statement) {
        ConditionList where = statement.getWhereClause();
        if (where.size() == 0) {
            return "";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.getKeyword("WHERE"));
        sql.append(" ");
        sql.append(this.mRegistry.getSql(where));
        return sql.toString();
    }

    public String createSql(UpdateStatement statement) {
        if (statement.getUpdateFields().size() == 0) {
            throw new IllegalArgumentException("No field defined in update statement");
        }
        UpdateTarget target = statement.getUpdateTarget();
        if (target.getAlias() == null) {
            target.setAlias("t");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.getKeyword("UPDATE"));
        sql.append(" ");
        sql.append(this.mRegistry.getSql(statement.getUpdateTarget()));
        sql.append("\r\n");
        sql.append(this.getKeyword("SET")).append(" ");
        sql.append(this.createUpdateList(statement.getUpdateFields()));
        sql.append("\r\n");
        sql.append(this.createWherePart(statement));
        return sql.toString();
    }

    public String createSql(ISqlStatement statement) {
        if (statement instanceof UpdateStatement) {
            return this.createSql((UpdateStatement)statement);
        }
        if (statement instanceof UpdateTarget) {
            return this.createSql((UpdateTarget)statement);
        }
        if (statement instanceof UpdateField) {
            return this.createSql((UpdateField)statement);
        }
        return null;
    }
}

