/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql.builder;

import aurora.database.profile.DatabaseProfile;
import aurora.database.sql.CompareExpression;
import aurora.database.sql.ComplexExpression;
import aurora.database.sql.Condition;
import aurora.database.sql.ConditionList;
import aurora.database.sql.ExistsClause;
import aurora.database.sql.ILogicalExpression;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.OracleJoinExpression;
import aurora.database.sql.RawSqlExpression;
import aurora.database.sql.builder.AbstractSqlBuilder;

public class ConditionListBuilder
extends AbstractSqlBuilder {
    protected String createSql(Condition condition, boolean first) {
        ILogicalExpression exp;
        boolean use_parentheses;
        StringBuffer result = new StringBuffer();
        if (!first) {
            result.append(" ");
            result.append(condition.getLogicalOperator());
            result.append(" ");
        }
        if (use_parentheses = (exp = condition.getExpression()) instanceof ConditionList) {
            boolean bl = use_parentheses = ((ConditionList)exp).size() > 1;
        }
        if (use_parentheses) {
            result.append(" (");
        }
        result.append(this.mRegistry.getSql(exp));
        if (use_parentheses) {
            result.append(") ");
        }
        return result.toString();
    }

    public String createSql(ComplexExpression exp) {
        return exp.toSql();
    }

    public String createSql(RawSqlExpression exp) {
        return exp.toSql();
    }

    public String createSql(ExistsClause clause) {
        StringBuffer result = new StringBuffer();
        result.append(clause.getType());
        result.append(" (");
        result.append(this.mRegistry.getSql(clause.getQuery()));
        result.append(") ");
        return result.toString();
    }

    public String createSql(CompareExpression exp) {
        String join_type;
        boolean is_oracle_join = exp instanceof OracleJoinExpression;
        if (DatabaseProfile.isUseJoinKeyword(this.getDatabaseProfile())) {
            is_oracle_join = false;
        }
        OracleJoinExpression join = is_oracle_join ? (OracleJoinExpression)exp : null;
        String string = join_type = is_oracle_join ? join.getJoinType() : null;
        if (exp.getLeftField() == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        result.append(this.mRegistry.getSql(exp.getLeftField()));
        if (is_oracle_join && ("RIGHT OUTER JOIN".equalsIgnoreCase(join_type) || "FULL OUTER JOIN".equalsIgnoreCase(join_type))) {
            result.append("(+)").append(' ');
        }
        result.append(' ');
        result.append(CompareExpression.getOperatorText(exp.getOperator()));
        if (!CompareExpression.isSingleOperator(exp.getOperator())) {
            result.append(' ');
            result.append(this.mRegistry.getSql(exp.getRightField()));
        }
        if (is_oracle_join && ("LEFT OUTER JOIN".equalsIgnoreCase(join_type) || "FULL OUTER JOIN".equalsIgnoreCase(join_type))) {
            result.append("(+)");
        }
        return result.toString();
    }

    public String createSql(ConditionList list) {
        int id = 0;
        StringBuffer result = new StringBuffer();
        for (Condition condition : list.getConditions()) {
            result.append(this.createSql(condition, id == 0));
            ++id;
        }
        return result.toString();
    }

    public String createSql(ISqlStatement sqlStatement) {
        if (sqlStatement instanceof ConditionList) {
            return this.createSql((ConditionList)sqlStatement);
        }
        if (sqlStatement instanceof CompareExpression) {
            return this.createSql((CompareExpression)sqlStatement);
        }
        if (sqlStatement instanceof ExistsClause) {
            return this.createSql((ExistsClause)sqlStatement);
        }
        if (sqlStatement instanceof ComplexExpression) {
            return this.createSql((ComplexExpression)sqlStatement);
        }
        if (sqlStatement instanceof RawSqlExpression) {
            return this.createSql((RawSqlExpression)sqlStatement);
        }
        return null;
    }
}

