/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.profile;

import aurora.database.profile.IDatabaseProfile;
import aurora.database.profile.ISqlBuilder;
import aurora.database.profile.ISqlBuilderRegistry;
import aurora.database.sql.CompareExpression;
import aurora.database.sql.ComplexExpression;
import aurora.database.sql.CompositeStatement;
import aurora.database.sql.ConditionList;
import aurora.database.sql.DeleteStatement;
import aurora.database.sql.ExistsClause;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.InsertStatement;
import aurora.database.sql.Join;
import aurora.database.sql.OracleJoinExpression;
import aurora.database.sql.OrderByField;
import aurora.database.sql.RawSqlExpression;
import aurora.database.sql.SelectField;
import aurora.database.sql.SelectSource;
import aurora.database.sql.SelectStatement;
import aurora.database.sql.UpdateField;
import aurora.database.sql.UpdateStatement;
import aurora.database.sql.UpdateTarget;
import aurora.database.sql.builder.AbstractSqlBuilder;
import aurora.database.sql.builder.ConditionListBuilder;
import aurora.database.sql.builder.DefaultCompositeBuilder;
import aurora.database.sql.builder.DefaultDeleteBuilder;
import aurora.database.sql.builder.DefaultInsertBuilder;
import aurora.database.sql.builder.DefaultJoinBuilder;
import aurora.database.sql.builder.DefaultSelectBuilder;
import aurora.database.sql.builder.DefaultUpdateBuilder;
import java.util.HashMap;
import java.util.Map;

public class SqlBuilderRegistry
implements ISqlBuilderRegistry {
    IDatabaseProfile databaseProfile;
    Map sqlBuilderMap = new HashMap();
    Map sqlBuilderTypeMap = new HashMap();
    ISqlBuilderRegistry parent;

    protected void loadDefaultBuilders() {
        AbstractSqlBuilder builder = new DefaultSelectBuilder();
        this.registerSqlBuilder(SelectStatement.class, builder);
        this.registerSqlBuilder(SelectSource.class, builder);
        this.registerSqlBuilder(SelectField.class, builder);
        this.registerSqlBuilder(OrderByField.class, builder);
        builder = new ConditionListBuilder();
        this.registerSqlBuilder(ConditionList.class, builder);
        this.registerSqlBuilder(CompareExpression.class, builder);
        this.registerSqlBuilder(ExistsClause.class, builder);
        this.registerSqlBuilder(ComplexExpression.class, builder);
        this.registerSqlBuilder(RawSqlExpression.class, builder);
        this.registerSqlBuilder(OracleJoinExpression.class, builder);
        builder = new DefaultUpdateBuilder();
        this.registerSqlBuilder(UpdateStatement.class, builder);
        this.registerSqlBuilder(UpdateTarget.class, builder);
        this.registerSqlBuilder(UpdateField.class, builder);
        builder = new DefaultInsertBuilder();
        this.registerSqlBuilder(InsertStatement.class, builder);
        builder = new DefaultDeleteBuilder();
        this.registerSqlBuilder(DeleteStatement.class, builder);
        builder = new DefaultCompositeBuilder();
        this.registerSqlBuilder(CompositeStatement.class, builder);
        builder = new DefaultJoinBuilder();
        this.registerSqlBuilder(Join.class, builder);
    }

    public SqlBuilderRegistry() {
        this.loadDefaultBuilders();
    }

    public SqlBuilderRegistry(IDatabaseProfile databaseProfile) {
        this.databaseProfile = databaseProfile;
        this.loadDefaultBuilders();
    }

    public void setDatabaseProfile(IDatabaseProfile database_profile) {
        this.databaseProfile = database_profile;
    }

    public IDatabaseProfile getDatabaseProfile() {
        return this.databaseProfile;
    }

    public ISqlBuilder getBuilder(ISqlStatement statement) {
        ISqlBuilder builder = (ISqlBuilder)this.sqlBuilderMap.get(statement.getClass());
        if (builder == null && this.parent != null) {
            builder = this.parent.getBuilder(statement);
        }
        return builder;
    }

    public void registerSqlBuilder(Class statement_type, ISqlBuilder sql_builder) {
        if (sql_builder.getRegistry() != this) {
            sql_builder.setRegistry(this);
        }
        this.sqlBuilderMap.put(statement_type, sql_builder);
        this.sqlBuilderTypeMap.put(sql_builder.getClass(), sql_builder);
    }

    public ISqlBuilder getSqlBuilderByType(Class builder_type) {
        return (ISqlBuilder)this.sqlBuilderTypeMap.get(builder_type);
    }

    public String getSql(ISqlStatement statement) {
        ISqlBuilder builder = this.getBuilder(statement);
        if (builder != null) {
            return builder.createSql(statement);
        }
        return null;
    }

    public ISqlBuilderRegistry getParent() {
        return this.parent;
    }

    public void setParent(ISqlBuilderRegistry parent) {
        assert (parent != this);
        this.parent = parent;
    }
}

