/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.profile;

import aurora.database.profile.IDatabaseFactory;
import aurora.database.profile.IDatabaseProfile;
import aurora.database.profile.ISqlBuilderRegistry;
import aurora.database.profile.SqlBuilderRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.event.ParticipantManager;
import uncertain.ocm.ClassRegistry;

public class DatabaseFactory
implements IDatabaseFactory {
    ISqlBuilderRegistry mDefaultSqlBuilderRegistry;
    String mDefaultDatabaseName;
    Map mDatabaseProfileMap = new HashMap();
    ClassRegistry mClassRegistry;
    ParticipantManager mParticipantManager;
    CompositeMap mProperties = new CompositeMap("properties");

    public DatabaseFactory() {
        this.mDefaultSqlBuilderRegistry = new SqlBuilderRegistry();
    }

    public IDatabaseProfile getDatabaseProfile(String database_name) {
        return (IDatabaseProfile)this.mDatabaseProfileMap.get(database_name);
    }

    public IDatabaseProfile[] getDatabases() {
        HashSet s = new HashSet();
        s.addAll(this.mDatabaseProfileMap.values());
        int length = s.size();
        IDatabaseProfile[] profile = new IDatabaseProfile[length];
        Object[] obj = s.toArray();
        System.arraycopy(obj, 0, profile, 0, length);
        return profile;
    }

    public void setDatabases(IDatabaseProfile[] databases) {
        int i = 0;
        while (i < databases.length) {
            this.addDatabaseProfile(databases[i]);
            ++i;
        }
    }

    public void addDatabaseProfile(IDatabaseProfile profile) {
        String name = profile.getDatabaseName();
        if (name == null) {
            throw new IllegalArgumentException("Must set databaseName for database profile");
        }
        this.mDatabaseProfileMap.put(name, profile);
        profile.setOwner(this);
        ISqlBuilderRegistry reg = profile.getSqlBuilderRegistry();
        if (reg != null) {
            reg.setParent(this.mDefaultSqlBuilderRegistry);
        }
        if (name.equals(this.mDefaultDatabaseName)) {
            this.mDefaultSqlBuilderRegistry.setDatabaseProfile(profile);
        }
    }

    public void addProperties(CompositeMap propers) {
        this.mProperties.copy(propers);
    }

    public String getDefaultDatabase() {
        return this.mDefaultDatabaseName;
    }

    public void setDefaultDatabase(String database) {
        this.mDefaultDatabaseName = database;
        IDatabaseProfile prof = (IDatabaseProfile)this.mDatabaseProfileMap.get(database);
        if (prof != null && this.mDefaultSqlBuilderRegistry != null) {
            this.mDefaultSqlBuilderRegistry.setDatabaseProfile(prof);
        }
    }

    public void addClassRegistry(ClassRegistry reg) {
        this.mClassRegistry = reg;
    }

    public ClassRegistry getClassRegistry() {
        return this.mClassRegistry;
    }

    public void addParticipantManager(ParticipantManager pm) {
        this.mParticipantManager = pm;
    }

    public ParticipantManager getParticipantManager() {
        return this.mParticipantManager;
    }

    public IDatabaseProfile getDefaultDatabaseProfile() {
        if (this.mDefaultDatabaseName == null) {
            throw new IllegalArgumentException("default database name not set");
        }
        IDatabaseProfile prof = this.getDatabaseProfile(this.mDefaultDatabaseName);
        if (prof == null) {
            throw new IllegalArgumentException("specified default database name " + this.mDefaultDatabaseName + " not found");
        }
        return prof;
    }

    public Object getProperty(String key) {
        return this.mProperties.get(key);
    }

    public CompositeMap getProperties() {
        return this.mProperties;
    }

    public void setProperty(String key, Object value) {
        this.mProperties.put(key, value);
    }

    public ISqlBuilderRegistry getDefaultSqlBuilderRegistry() {
        return this.mDefaultSqlBuilderRegistry;
    }

    public void setDefaultSqlBuilderRegistry(ISqlBuilderRegistry reg) {
        this.mDefaultSqlBuilderRegistry = reg;
    }
}

