/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.features;

import aurora.database.DBUtil;
import aurora.database.IResultSetConsumer;
import aurora.database.ParsedSql;
import aurora.database.SqlRunner;
import aurora.database.service.ServiceOption;
import aurora.database.service.SqlServiceContext;
import java.sql.ResultSet;
import uncertain.ocm.ISingleton;

public class AutoQueryCounter
implements ISingleton {
    public void onQueryFinish(SqlServiceContext context) throws Exception {
        ServiceOption option = context.getServiceOption();
        if (option == null) {
            return;
        }
        IResultSetConsumer consumer = context.getResultsetConsumer();
        if (consumer == null) {
            return;
        }
        if (option.isAutoCount()) {
            long count = 0L;
            StringBuffer oldsql = context.getSqlString();
            if (oldsql == null) {
                return;
            }
            StringBuffer sql = new StringBuffer(oldsql.toString());
            sql.insert(0, "select count(1) from ( ");
            sql.append(" ) s");
            ParsedSql s = new ParsedSql(sql.toString());
            SqlRunner runner = new SqlRunner(context, s);
            runner.setConnectionName(option.getConnectionName());
            runner.setTrace(context.isTrace());
            ResultSet rs = null;
            try {
                rs = runner.query(context.getCurrentParameter());
                if (rs.next()) {
                    count = rs.getLong(1);
                }
                consumer.setRecordCount(count);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                throw throwable;
            }
            DBUtil.closeResultSet(rs);
        }
    }
}

