/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.actions;

import aurora.database.FetchDescriptor;
import aurora.database.IResultSetConsumer;
import aurora.database.actions.AbstractQueryAction;
import aurora.database.service.BusinessModelService;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.service.DatabaseServiceFactory;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.OCManager;

public class ModelQuery
extends AbstractQueryAction {
    String model;
    DatabaseServiceFactory svcFactory;
    BusinessModelService service;
    BusinessModelServiceContext serviceContext;

    public ModelQuery(DatabaseServiceFactory svcFactory, OCManager manager) {
        super(manager);
        this.svcFactory = svcFactory;
    }

    public BusinessModelService getService() {
        return this.service;
    }

    public DatabaseServiceFactory getServiceFactory() {
        return this.svcFactory;
    }

    public String getModel() {
        return this.model;
    }

    public String getName() {
        return String.valueOf(super.getName()) + "[" + this.getModel() + "]";
    }

    protected void doQuery(CompositeMap param, IResultSetConsumer consumer, FetchDescriptor desc) throws Exception {
        this.service.query(param, consumer, desc);
    }

    protected void prepare(CompositeMap context) throws Exception {
        if (this.model == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "model");
        }
        ILogger logger = LoggingContext.getLogger(context, "aurora.database");
        String parsed_model = TextParser.parse(this.model, context);
        logger.config("===================================== prepare to run model-query " + parsed_model + "==============================");
        this.service = this.svcFactory.getModelService(parsed_model, context);
        this.setConnectionName(this.service.getBusinessModel().getDataSourceName());
        this.serviceContext = (BusinessModelServiceContext)DynamicObject.cast(context, BusinessModelServiceContext.class);
    }

    protected void cleanUp(CompositeMap context) {
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void beginConfigure(CompositeMap config) {
        super.beginConfigure(config);
    }
}

