/*
 * Decompiled with CFR 0.152.
 */
package aurora.database;

import aurora.database.BindDescriptor;
import aurora.database.BindParameter;
import aurora.database.DBUtil;
import aurora.database.DynamicSqlParseHandle;
import aurora.database.ParsedSql;
import aurora.database.service.SqlServiceContext;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uncertain.composite.CompositeAccessor;
import uncertain.composite.CompositeMap;
import uncertain.composite.ICompositeAccessor;
import uncertain.event.RuntimeContext;

public class SqlRunner {
    boolean trace = true;
    boolean use_batch_update = true;
    ParsedSql statement;
    ICompositeAccessor parameter_accessor = CompositeAccessor.defaultInstance();
    SqlServiceContext context;
    Connection conn = null;
    List bind_param_list;
    long exec_time;
    String connectionName;

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    static void setException(RuntimeContext context, Throwable ex) {
        context.setException(ex);
        context.setSuccess(false);
    }

    public static void fireUpdateFail(SqlServiceContext context, Throwable thr) {
        SqlRunner.setException(context, thr);
        context.fireEvent("UpdateFail", new Object[]{context});
    }

    public static void fireUpdateRecordFail(SqlServiceContext context, CompositeMap record, Throwable thr) {
        if (thr != null) {
            context.setException(thr);
        }
        context.fireEvent("UpdateRecordFail", new Object[]{context});
    }

    public static Collection getSourceParameter(CompositeMap context, String path) {
        if (path == null) {
            return context.getChilds();
        }
        if (".".equals(path)) {
            ArrayList<CompositeMap> lst = new ArrayList<CompositeMap>(1);
            lst.add(context);
            return lst;
        }
        Object obj = context.getObject(path);
        if (obj == null) {
            return null;
        }
        if (obj instanceof CompositeMap) {
            return ((CompositeMap)obj).getChilds();
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        return null;
    }

    public SqlRunner(SqlServiceContext context) {
        this.setSqlServiceContext(context);
        ICompositeAccessor accessor = context.getCompositeAccessor();
        if (accessor != null) {
            this.parameter_accessor = accessor;
        }
    }

    public SqlRunner(SqlServiceContext context, ParsedSql statement) {
        this(context);
        this.statement = statement;
    }

    public void setSqlServiceContext(SqlServiceContext context) {
        this.context = context;
        this.setTrace(context.isTrace());
    }

    void prepareConnection() throws SQLException {
        this.conn = this.connectionName != null ? this.context.getNamedConnection(this.connectionName) : this.context.getConnection();
        if (this.conn == null) {
            throw new IllegalStateException("No java.sql.Connection set in service context");
        }
    }

    public String generateSQL(CompositeMap param) {
        if (this.statement.isStaticStatement()) {
            return this.statement.getParsedSQL();
        }
        String sql = DynamicSqlParseHandle.processSql(this.statement.getOriginSQL(), param);
        this.statement.parse(sql);
        return this.statement.getParsedSQL();
    }

    void addBindDescriptor(BindDescriptor desc) {
        if (this.bind_param_list == null) {
            this.bind_param_list = new LinkedList();
        }
        this.bind_param_list.add(desc);
    }

    public List getBindDescriptors() {
        return this.bind_param_list;
    }

    public String getBindDescription() {
        if (this.bind_param_list == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (BindDescriptor bdesc : this.bind_param_list) {
            buf.append(bdesc.toString()).append("\r\n");
        }
        return buf.toString();
    }

    public void bindParameters(PreparedStatement ps, CompositeMap param) throws SQLException {
        if (this.isTrace() && this.bind_param_list != null) {
            this.bind_param_list.clear();
        }
        int index = 1;
        Iterator it = this.statement.getBindParameters().iterator();
        BindDescriptor bdesc = null;
        while (it.hasNext()) {
            BindParameter p = (BindParameter)it.next();
            if (p.is_sql_statement) continue;
            if (this.isTrace()) {
                bdesc = new BindDescriptor(p.input_path, null, index);
            }
            if (p.is_input) {
                Object value = this.parameter_accessor.get(param, p.input_path);
                p.setStatement(index, ps, value);
                if (this.isTrace()) {
                    bdesc.setValue(value);
                }
            }
            if (p.is_output) {
                CallableStatement cs = (CallableStatement)ps;
                if (p.database_type_name == null) {
                    cs.registerOutParameter(index, p.data_type.getSqlType());
                } else {
                    cs.registerOutParameter(index, p.data_type.getSqlType(), p.database_type_name);
                }
                if (this.isTrace()) {
                    bdesc.setOutput(true);
                    bdesc.setDatabaseType(p.database_type_name);
                }
            }
            ++index;
            if (!this.isTrace()) continue;
            this.addBindDescriptor(bdesc);
        }
    }

    public void fetchOutputParameters(CallableStatement cs, CompositeMap param) throws SQLException {
        int index = 1;
        for (BindParameter p : this.statement.getBindParameters()) {
            if (!p.is_sql_statement && p.is_output) {
                Object value = p.data_type.getObject(cs, index);
                this.parameter_accessor.put(param, p.output_path, value);
            }
            ++index;
        }
    }

    public ResultSet query(CompositeMap param) throws SQLException {
        this.prepareConnection();
        String sql = this.generateSQL(param);
        CallableStatement ps = this.conn.prepareCall(sql);
        this.bindParameters(ps, param);
        ResultSet rs = ps.executeQuery();
        return rs;
    }

    void setException(Throwable ex) {
        this.context.setException(ex);
        this.context.setSuccess(false);
    }

    protected int updateInternal(CompositeMap param, CompositeMap output) throws SQLException {
        int n;
        block4: {
            this.exec_time = 0L;
            this.prepareConnection();
            String sql = this.generateSQL(param);
            PreparedStatement ps = null;
            try {
                ps = this.statement.hasOutputParameter() ? this.conn.prepareCall(sql) : this.conn.prepareStatement(sql);
                this.bindParameters(ps, param);
                this.exec_time = System.currentTimeMillis();
                int result = ps.executeUpdate();
                this.exec_time = System.currentTimeMillis() - this.exec_time;
                if (this.statement.hasOutputParameter()) {
                    this.fetchOutputParameters((CallableStatement)ps, output);
                }
                n = result;
                if (ps == null) break block4;
            }
            catch (Throwable throwable) {
                if (ps != null) {
                    DBUtil.closeStatement(ps);
                }
                throw throwable;
            }
            DBUtil.closeStatement(ps);
        }
        return n;
    }

    public int update(CompositeMap param, CompositeMap output) throws SQLException {
        return this.updateInternal(param, output);
    }

    public int update(CompositeMap param) throws SQLException {
        return this.update(param, param);
    }

    public boolean updateList(Collection param_list) throws SQLException {
        long tick = System.currentTimeMillis();
        this.prepareConnection();
        boolean success = true;
        for (CompositeMap param : param_list) {
            this.context.setCurrentParameter(param);
            this.updateInternal(param, param);
        }
        this.context.setSuccess(success);
        this.exec_time = System.currentTimeMillis() - tick;
        return success;
    }

    public boolean updateListUsingBatch(Collection param_list) throws SQLException {
        boolean bl;
        boolean success = true;
        this.exec_time = 0L;
        this.prepareConnection();
        if (!this.statement.isStaticStatement()) {
            throw new IllegalStateException("Can't do batch update with sql statement that contains dynamic part");
        }
        String sql = this.statement.getParsedSQL();
        PreparedStatement ps = null;
        try {
            this.exec_time = System.currentTimeMillis();
            ps = this.conn.prepareStatement(sql);
            for (CompositeMap param : param_list) {
                this.bindParameters(ps, param);
                ps.addBatch();
            }
            ps.executeUpdate();
            this.exec_time = System.currentTimeMillis() - this.exec_time;
            bl = success;
        }
        catch (Throwable throwable) {
            DBUtil.closeStatement(ps);
            throw throwable;
        }
        DBUtil.closeStatement(ps);
        return bl;
    }

    public ParsedSql getStatement() {
        return this.statement;
    }

    public void setStatement(ParsedSql statement) {
        this.statement = statement;
    }

    public boolean isTrace() {
        return true;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public SqlServiceContext getSqlServiceContext() {
        return this.context;
    }

    public long getLastExecutionTime() {
        return this.exec_time;
    }
}

