/*
 * Decompiled with CFR 0.152.
 */
package aurora.database;

import aurora.service.ServiceContext;
import aurora.service.exception.BaseExceptionDescriptor;
import aurora.service.exception.IExceptionDescriptor;
import aurora.service.validation.ErrorMessage;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.core.ConfigurationError;

public class SQLExceptionDescriptor
implements IExceptionDescriptor {
    Map mMessageMap;
    String mDefaultMessage;

    public CompositeMap process(ServiceContext context, Throwable exception) {
        return this.getParsedError(context, exception);
    }

    public ErrorMessage getErrorMessage(SQLException sex) {
        int code = sex.getErrorCode();
        if (this.mMessageMap != null) {
            ErrorMessage msg = (ErrorMessage)this.mMessageMap.get(Integer.toString(code));
            return msg;
        }
        return null;
    }

    public CompositeMap getParsedError(ServiceContext context, Throwable exception) {
        if (!(exception instanceof SQLException)) {
            return null;
        }
        SQLException sex = (SQLException)exception;
        if (sex.getCause() != null && sex.getCause() instanceof SQLException) {
            sex = (SQLException)sex.getCause();
        }
        String error_msg = null;
        ErrorMessage msgObj = this.getErrorMessage(sex);
        if (msgObj != null) {
            error_msg = msgObj.getMessage();
        }
        if (error_msg == null && this.mDefaultMessage != null) {
            error_msg = this.mDefaultMessage;
        }
        if (error_msg == null) {
            return null;
        }
        error_msg = BaseExceptionDescriptor.getTranslatedMessage(error_msg, context);
        CompositeMap error = new CompositeMap("error-message");
        if (msgObj != null) {
            error.copy(msgObj.getObjectContext());
        } else {
            error.put("code", Integer.toString(sex.getErrorCode()));
        }
        error.put("message", error_msg);
        return error;
    }

    public void addErrorMessage(CompositeMap msg) {
        ErrorMessage m = (ErrorMessage)DynamicObject.cast(msg, ErrorMessage.class);
        String code = m.getCode();
        if (code == null) {
            throw new ConfigurationError("Must set 'code' property in " + m.getObjectContext().toXML());
        }
        if (this.mMessageMap == null) {
            this.mMessageMap = new HashMap();
        }
        this.mMessageMap.put(code, m);
    }

    public String getDefaultMessage() {
        return this.mDefaultMessage;
    }

    public void setDefaultMessage(String defaultMessage) {
        this.mDefaultMessage = defaultMessage;
    }
}

