/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.admin;

import aurora.application.admin.CommandHandleThread;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import uncertain.core.EngineInitiator;

public class ServerAdmin
extends Thread {
    int mPort;
    ServerSocket mSocket;
    String mHome;
    boolean mIsRunning = true;
    EngineInitiator mEngineInitiator;
    List mClientThreadList;

    public ServerAdmin(int port, String home) {
        this.mPort = port;
        this.mHome = home;
    }

    public void doShutdown() {
        this.mIsRunning = false;
        if (this.mClientThreadList != null) {
            for (CommandHandleThread thread : this.mClientThreadList) {
                thread.clearUp();
            }
            this.mClientThreadList.clear();
            this.mClientThreadList = null;
        }
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.mSocket = null;
        }
        if (this.mEngineInitiator != null) {
            if (this.mEngineInitiator.getUncertainEngine() != null && this.mEngineInitiator.getUncertainEngine().getIsRunning()) {
                this.mEngineInitiator.getUncertainEngine().shutdown();
            }
            this.mEngineInitiator = null;
        }
    }

    public void doStartup() {
        this.doShutdown();
        try {
            this.mSocket = new ServerSocket(this.mPort);
            this.mClientThreadList = new LinkedList();
            File home_path = new File(this.mHome);
            File config_path = new File(home_path, "WEB-INF");
            this.mEngineInitiator = new EngineInitiator(home_path, config_path);
            System.out.println("init EngineInitiator");
            this.mEngineInitiator.init();
            this.mIsRunning = true;
            this.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void addClient(CommandHandleThread thread) {
        this.mClientThreadList.add(thread);
    }

    void removeClient(CommandHandleThread thread) {
        thread.clearUp();
        this.mClientThreadList.remove(thread);
    }

    public void run() {
        while (this.mIsRunning) {
            try {
                Socket socket = this.mSocket.accept();
                String address = socket.getInetAddress().getHostAddress();
                if (!"127.0.0.1".equals(address)) {
                    socket.close();
                    continue;
                }
                CommandHandleThread thread = new CommandHandleThread(this, socket);
                this.addClient(thread);
                thread.start();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    static void printUsage() {
        System.out.println("Usage:");
        System.out.println("ServerAdmin <port> <lwap home directory>");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            ServerAdmin.printUsage();
            return;
        }
        try {
            int port = Integer.parseInt(args[0]);
            File path = new File(args[1]);
            if (!path.exists()) {
                throw new IllegalArgumentException(String.valueOf(path.getPath()) + " doesn't exist");
            }
            ServerAdmin admin = new ServerAdmin(port, path.getPath());
            admin.doStartup();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ServerAdmin.printUsage();
            return;
        }
    }
}

