/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.action;

import aurora.security.IResourceAccessChecker;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.ProgrammingException;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class ResourceAccessCheck
extends AbstractEntry {
    IResourceAccessChecker mChecker;
    String resultPath;
    String serviceNamePath = "@service_name";

    public ResourceAccessCheck(IResourceAccessChecker mChecker) {
        this.mChecker = mChecker;
    }

    public void run(ProcedureRunner runner) throws Exception {
        if (this.resultPath == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "resultPath");
        }
        CompositeMap context = runner.getContext();
        ILogger logger = LoggingContext.getLogger(context, "aurora.application.session_check");
        String service_name = (String)context.getObject(this.serviceNamePath);
        if (service_name == null) {
            throw new ProgrammingException("'service_name' from " + this.serviceNamePath + " is null");
        }
        String result = this.mChecker.checkAccess(service_name, context);
        logger.log(Level.CONFIG, "Access check result for {0} => {1}", new Object[]{service_name, result});
        context.putObject(this.resultPath, (Object)result, true);
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public void setResultPath(String resultPath) {
        this.resultPath = resultPath;
    }

    public String getServiceNamePath() {
        return this.serviceNamePath;
    }

    public void setServiceNamePath(String serviceNamePath) {
        this.serviceNamePath = serviceNamePath;
    }
}

