/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.action;

import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class HttpSessionOperate
extends AbstractEntry {
    public static final String SESSION_WRITE = "session-write";
    public static final String SESSION_CLEAR = "session-clear";
    public static final String SESSION_CREATE = "session-create";
    String mOperationName;
    String mSource;
    String mTarget;

    public String getSource() {
        return this.mSource;
    }

    public void setSource(String source) {
        this.mSource = source;
    }

    public String getTarget() {
        return this.mTarget;
    }

    public void setTarget(String target) {
        this.mTarget = target;
    }

    public void beginConfigure(CompositeMap config) {
        super.beginConfigure(config);
        this.mOperationName = config.getName();
    }

    void writeAllFields(CompositeMap map, HttpSession session) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key == null) continue;
            session.setAttribute(key.toString(), entry.getValue());
        }
    }

    public void writeSession(HttpServletRequest request, CompositeMap context) {
        ILogger mLogger = LoggingContext.getLogger(context, "aurora.application.session_check");
        CompositeMap session_map = null;
        if (this.mSource == null) {
            session_map = (CompositeMap)context.getObject("/session");
            if (session_map == null) {
                mLogger.warning("Can't get /session section in service context");
                return;
            }
            HttpSession session = request.getSession(true);
            this.writeAllFields(session_map, session);
            return;
        }
        if (this.mTarget != null) {
            HttpSession session = request.getSession(true);
            Object value = context.getObject(this.mSource);
            session.setAttribute(this.mTarget, value);
        } else {
            Object value = context.getObject(this.mSource);
            if (value == null) {
                mLogger.warning("source element not found from path '" + this.mSource + "'");
                return;
            }
            if (value instanceof CompositeMap) {
                HttpSession session = request.getSession(true);
                session_map = (CompositeMap)value;
                this.writeAllFields(session_map, session);
            } else {
                throw new IllegalArgumentException("Object from '" + this.mSource + "' is not instance of CompositeMap, but " + value.getClass().getName());
            }
        }
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance(context);
        HttpServletRequest request = svc.getRequest();
        if (SESSION_WRITE.equalsIgnoreCase(this.mOperationName)) {
            this.writeSession(request, context);
        } else if (SESSION_CLEAR.equalsIgnoreCase(this.mOperationName)) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
        } else if (SESSION_CREATE.equalsIgnoreCase(this.mOperationName)) {
            request.getSession(true);
        }
    }
}

