/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.IDocServer;
import java.io.File;
import uncertain.core.IGlobalInstance;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class IDocServerInstance
implements IGlobalInstance {
    public static final String PLUGIN = "aurora.plugin.sap.sync.idoc";
    public String SERVER_NAME_LIST;
    public String IDOC_DIR;
    private IObjectRegistry registry;
    public ILogger logger;
    public static final String SEPARATOR = ",";
    public String DeleteImmediately = "Y";
    private String version = "1.2";

    public IDocServerInstance(IObjectRegistry registry) {
        this.registry = registry;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public IObjectRegistry getRegistry() {
        return this.registry;
    }

    public void log(String message) {
        if (this.logger != null) {
            this.logger.info(message);
        } else {
            System.out.println(message);
        }
    }

    public void onInitialize() throws Exception {
        this.logger = LoggingContext.getLogger((String)PLUGIN, (IObjectRegistry)this.registry);
        this.run();
    }

    public String getIdocDir() {
        return this.IDOC_DIR;
    }

    public String getServerNameList() {
        return this.SERVER_NAME_LIST;
    }

    public void run() {
        this.log("idoc version: " + this.version);
        this.log("IDOC_DIR:" + this.IDOC_DIR);
        if (this.IDOC_DIR == null || "".equals(this.IDOC_DIR)) {
            throw new IllegalArgumentException("IDOC_DIR can not be null !");
        }
        File file = new File(this.IDOC_DIR);
        if (!file.exists()) {
            throw new IllegalArgumentException("IDOC_DIR:" + this.IDOC_DIR + " is not exists!");
        }
        this.log("SERVER_NAME_LIST:" + this.SERVER_NAME_LIST);
        if (this.SERVER_NAME_LIST == null || this.SERVER_NAME_LIST.equals("")) {
            throw new IllegalArgumentException("SERVER_NAME_LIST can not be null !");
        }
        String[] servers = this.SERVER_NAME_LIST.split(SEPARATOR);
        String serverName = null;
        IDocServer server = null;
        int i = 0;
        while (i < servers.length) {
            serverName = servers[i];
            server = new IDocServer(this, serverName);
            server.start();
            ++i;
        }
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public void setRegistry(IObjectRegistry registry) {
        this.registry = registry;
    }

    public boolean isDeleteImmediately() {
        return "Y".equals(this.DeleteImmediately);
    }
}

