/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap;

import aurora.plugin.sap.InstanceConfig;
import aurora.plugin.sap.Parameter;
import aurora.plugin.sap.SapConfig;
import aurora.plugin.sap.SapInstance;
import aurora.plugin.sap.Structure;
import aurora.plugin.sap.Table;
import aurora.service.http.HttpServiceInstance;
import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.ConfigurationError;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class JcoInvoke
extends AbstractEntry {
    SapConfig sapConfig;
    InstanceConfig sapInstance;
    ILogger logger;
    public Parameter[] parameters;
    public String sid;
    public Table[] tables;
    public Structure[] structures;
    public String function;
    public String return_target;

    public JcoInvoke(SapConfig config) {
        this.sapConfig = config;
    }

    public JcoInvoke(SapInstance si) {
        this.sapInstance = si;
    }

    public void run(ProcedureRunner runner) throws Exception {
        JCO.Client client;
        block36: {
            String t;
            CompositeMap context = runner.getContext();
            if (this.sapConfig != null) {
                this.sid = TextParser.parse((String)this.sid, (CompositeMap)context);
                if (this.sid == null) {
                    this.sapInstance = this.sapConfig.getSapInstance();
                    if (this.sapInstance == null) {
                        throw new IllegalArgumentException("jco-invoke: sid attribute is null");
                    }
                } else {
                    this.sapInstance = this.sapConfig.getSapInstance(this.sid);
                }
            }
            this.logger = LoggingContext.getLogger((CompositeMap)context, (String)"aurora.plugin.sap");
            this.logger.config("jco-invoke");
            this.logger.config("===================================");
            this.logger.log(Level.CONFIG, "config:{0}", new Object[]{this});
            HttpServiceInstance service = (HttpServiceInstance)HttpServiceInstance.getInstance((CompositeMap)context.getRoot());
            CompositeMap target = null;
            CompositeMap model = null;
            model = service != null ? service.getServiceContext().getModel() : context.getRoot().getChild("model");
            if (model == null) {
                model = context.getRoot().createChild("model");
            }
            if (this.return_target != null && (target = (CompositeMap)model.getObject(t = TextParser.parse((String)this.return_target, (CompositeMap)context))) == null) {
                target = model.createChildByTag(t);
            }
            IRepository repository = this.sapInstance.getRepository();
            client = null;
            try {
                IFunctionTemplate ftemplate = repository.getFunctionTemplate(this.function);
                this.logger.info("function template:" + this.function);
                if (ftemplate != null) {
                    Table table;
                    JCO.Structure stc;
                    int i;
                    JCO.Function function = ftemplate.getFunction();
                    client = this.sapInstance.getClient();
                    this.logger.config("connected to " + this.sapInstance.getServer_ip() + ":" + this.sapInstance.getSid());
                    JCO.ParameterList input = function.getImportParameterList();
                    JCO.ParameterList output = function.getExportParameterList();
                    if (this.parameters != null) {
                        i = 0;
                        while (i < this.parameters.length) {
                            Parameter param = this.parameters[i];
                            if (param.Return_field == null) {
                                String o = param.Source_field == null ? param.Value : context.getObject(param.Source_field);
                                String value = o == null ? "" : o.toString();
                                input.setValue(value, param.Name);
                                this.logger.log(Level.CONFIG, "parameter {0} -> {1}", new Object[]{param.Name, value});
                            }
                            ++i;
                        }
                    }
                    if (this.structures != null) {
                        i = 0;
                        while (i < this.structures.length) {
                            Structure structure = this.structures[i];
                            structure.setLogger(this.logger);
                            if (structure.isImport()) {
                                stc = structure.getJCOStructure(input);
                                structure.fillJCOStructure(stc, context);
                                input.setValue(stc, structure.Name);
                            }
                            ++i;
                        }
                    }
                    if (this.tables != null) {
                        JCO.ParameterList list = function.getTableParameterList();
                        int i2 = 0;
                        while (i2 < this.tables.length) {
                            table = this.tables[i2];
                            table.setLogger(this.logger);
                            if (table.isImport()) {
                                JCO.Table tbl = table.getJCOTable(list);
                                Object o = context.getObject(table.Source_field);
                                this.logger.config("transfer import table " + table.Name + " from '" + table.Source_field + "':" + o);
                                if (o instanceof CompositeMap) {
                                    table.fillJCOTable(tbl, context);
                                }
                            }
                            ++i2;
                        }
                    }
                    this.logger.config("call function " + function);
                    client.execute(function);
                    if (this.parameters != null) {
                        int i3 = 0;
                        while (i3 < this.parameters.length) {
                            Parameter param = this.parameters[i3];
                            if (param.Return_field != null) {
                                if (target == null) {
                                    throw new ConfigurationError("<jco-invoke>:must set 'return_target' attribute if there is return field");
                                }
                                String vl = output.getString(param.Name);
                                if (vl == null && !param.Nullable) {
                                    throw new IllegalArgumentException("jco-invoke: return field " + param.Name + " is null");
                                }
                                String f = TextParser.parse((String)param.Return_field, (CompositeMap)context);
                                target.putObject(f, (Object)vl);
                                this.logger.config("return: " + param.Name + "=" + vl + " -> " + f);
                            }
                            ++i3;
                        }
                    }
                    if (this.structures != null) {
                        int i4 = 0;
                        while (i4 < this.structures.length) {
                            Structure structure = this.structures[i4];
                            structure.setLogger(this.logger);
                            if (!structure.isImport()) {
                                if (structure.Target == null) {
                                    throw new ConfigurationError("Must set 'target' attribute for Structures " + structure.Name);
                                }
                                stc = structure.getJCOStructure(output);
                                CompositeMap result = (CompositeMap)context.getObject(structure.Target);
                                if (result == null) {
                                    result = context.createChildByTag(structure.Target);
                                }
                                structure.fillCompositeMap(stc, result);
                            }
                            ++i4;
                        }
                    }
                    if (this.tables != null) {
                        JCO.ParameterList list = function.getTableParameterList();
                        if (list == null) {
                            throw new IllegalArgumentException("Function '" + function + "' doesn't return tables");
                        }
                        int i5 = 0;
                        while (i5 < this.tables.length) {
                            table = this.tables[i5];
                            if (!table.isImport()) {
                                if (table.Target == null) {
                                    throw new ConfigurationError("Must set 'target' attribute for table " + table.Name);
                                }
                                table.setLogger(this.logger);
                                JCO.Table records = table.getJCOTable(list);
                                CompositeMap result = (CompositeMap)context.getObject(table.Target);
                                if (result == null) {
                                    result = context.createChildByTag(table.Target);
                                }
                                table.fillCompositeMap(records, result);
                                int rc = 0;
                                if (result.getChilds() != null) {
                                    rc = result.getChilds().size();
                                }
                                this.logger.config("loading export table " + table.Name + " into path '" + table.Target + "', total " + rc + " record(s)");
                            }
                            ++i5;
                        }
                    }
                    this.logger.config("jco invoke finished");
                    break block36;
                }
                throw new IllegalArgumentException("Function '" + this.function + "' not found in SAP system.");
            }
            catch (Throwable throwable) {
                JCO.releaseClient(client);
                throw throwable;
            }
        }
        JCO.releaseClient((JCO.Client)client);
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameter[] parameters) {
        this.parameters = parameters;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public Table[] getTables() {
        return this.tables;
    }

    public void setTables(Table[] tables) {
        this.tables = tables;
    }

    public Structure[] getStructures() {
        return this.structures;
    }

    public void setStructures(Structure[] structures) {
        this.structures = structures;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getReturn_target() {
        return this.return_target;
    }

    public void setReturn_target(String return_target) {
        this.return_target = return_target;
    }
}

