/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.ntlm;

import aurora.plugin.ntlm.DomainInstance;
import java.util.Iterator;
import java.util.Set;
import jcifs.Config;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class NtlmConfig {
    public String procedure;
    public String returnPath;
    CompositeMap domainInstances;
    IObjectRegistry mObjectRegistry;

    public NtlmConfig(IObjectRegistry registry) {
        this.mObjectRegistry = registry;
        Config.setProperty((String)"jcifs.smb.client.soTimeout", (String)"1800000");
        Config.setProperty((String)"jcifs.netbios.cachePolicy", (String)"1200");
        Config.setProperty((String)"jcifs.smb.lmCompatibility", (String)"0");
        Config.setProperty((String)"jcifs.smb.client.useExtendedSecurity", (String)"false");
    }

    public void onInitialize() {
        this.mObjectRegistry.registerInstance(NtlmConfig.class, (Object)this);
    }

    public DomainInstance getDomainInstance(String domain) {
        return (DomainInstance)this.domainInstances.get((Object)domain);
    }

    public DomainInstance getDefaultDomainInstance() {
        Set keySet = this.domainInstances.keySet();
        Iterator iterator = keySet.iterator();
        if (iterator.hasNext()) {
            return (DomainInstance)this.domainInstances.get(iterator.next());
        }
        return null;
    }

    public void addInstances(DomainInstance[] domainInstance) {
        this.domainInstances = new CompositeMap();
        int l = domainInstance.length;
        DomainInstance intance = null;
        int i = 0;
        while (i < l) {
            intance = domainInstance[i];
            this.domainInstances.put((Object)intance.getDomain(), (Object)intance);
            ++i;
        }
    }

    public String getProcedure() {
        if (this.procedure == null) {
            throw new RuntimeException("procedure is undefined");
        }
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public String getReturnPath() {
        if (this.returnPath == null) {
            throw new RuntimeException("returnPath is undefined");
        }
        return this.returnPath;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }
}

