/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.ntlm;

import aurora.plugin.ntlm.DomainInstance;
import aurora.plugin.ntlm.NtlmConfig;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.http.NtlmSsp;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbSession;
import jcifs.util.Base64;

public class NtlmAuthenticator {
    private String defaultDomain;
    private String domainController;
    NtlmConfig ntlmConfig;

    public NtlmAuthenticator(NtlmConfig ntlmConfig) {
        this.ntlmConfig = ntlmConfig;
    }

    public NtlmPasswordAuthentication authenticate(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        NtlmPasswordAuthentication ntlm = null;
        String msg = req.getHeader("Authorization");
        if (msg != null && msg.startsWith("NTLM ")) {
            Type1Message type1 = null;
            byte[] token = Base64.decode((String)msg.substring(5));
            if (token[8] == 1) {
                type1 = new Type1Message(token);
                this.defaultDomain = type1.getSuppliedDomain();
            } else if (token[8] == 3) {
                Type3Message type3 = new Type3Message(token);
                this.defaultDomain = type3.getDomain();
            }
            DomainInstance domainInstance = this.defaultDomain == null ? this.ntlmConfig.getDefaultDomainInstance() : this.ntlmConfig.getDomainInstance(this.defaultDomain);
            if (domainInstance == null) {
                throw new RuntimeException("DomainInstance is null;defaultDomain:" + this.defaultDomain + ";Workstation:" + type1.getSuppliedWorkstation());
            }
            this.domainController = domainInstance.getDomainController();
            Config.setProperty((String)"jcifs.smb.client.domain", (String)domainInstance.getDomain());
            Config.setProperty((String)"jcifs.smb.client.username", (String)domainInstance.getUserName());
            Config.setProperty((String)"jcifs.smb.client.password", (String)domainInstance.getPassword());
            UniAddress dc = UniAddress.getByName((String)this.domainController, (boolean)true);
            byte[] challenge = SmbSession.getChallenge((UniAddress)dc);
            ntlm = NtlmSsp.authenticate((HttpServletRequest)req, (HttpServletResponse)resp, (byte[])challenge);
            if (ntlm == null) {
                return null;
            }
            SmbSession.logon((UniAddress)dc, (NtlmPasswordAuthentication)ntlm);
            return ntlm;
        }
        resp.setHeader("WWW-Authenticate", "NTLM");
        resp.setStatus(401);
        resp.setContentLength(0);
        resp.flushBuffer();
        return null;
    }
}

