/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.jms;

import aurora.plugin.jms.JMSUtil;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IConfigurable;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;
import uncertain.util.resource.ILocatable;

public class JmsMessageDispatch
extends AbstractEntry
implements IConfigurable {
    public static final String MESSAGE_ATTR = "message";
    public static final String TOPIC_ATTR = "topic";
    private String message;
    private String topic;
    private IObjectRegistry registry;

    public JmsMessageDispatch(IObjectRegistry registry) {
        this.registry = registry;
    }

    public void run(ProcedureRunner runner) throws Exception {
        if (this.message == null) {
            BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)MESSAGE_ATTR);
        }
        if (this.topic == null) {
            BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)TOPIC_ATTR);
        }
        ILogger logger = LoggingContext.getLogger((CompositeMap)runner.getContext(), (String)"aurora.plugin.jms");
        ConnectionFactory connectionFactory = (ConnectionFactory)this.registry.getInstanceOfType(ConnectionFactory.class);
        if (connectionFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, ConnectionFactory.class);
        }
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            logger.log(Level.CONFIG, "create createTopic {0}", new Object[]{this.topic});
            Topic jmsTopic = session.createTopic(this.topic);
            messageProducer = session.createProducer((Destination)jmsTopic);
            logger.log(Level.CONFIG, "start producer connection");
            connection.start();
            logger.log(Level.CONFIG, "start producer successfull!");
            String real_message = TextParser.parse((String)this.message, (CompositeMap)runner.getContext());
            messageProducer.send((Message)session.createTextMessage(real_message));
            logger.log(Level.CONFIG, "Message:{0} sent", new Object[]{real_message});
        }
        catch (Throwable throwable) {
            JMSUtil.freeMessageProducer(messageProducer);
            JMSUtil.freeJMSSession(session);
            JMSUtil.freeJMSConnection(connection);
            throw throwable;
        }
        JMSUtil.freeMessageProducer(messageProducer);
        JMSUtil.freeJMSSession(session);
        JMSUtil.freeJMSConnection(connection);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String event) {
        this.message = event;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }
}

