/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.jms;

import aurora.plugin.jms.IMessageHandler;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import java.util.logging.Level;
import javax.jms.Message;
import javax.jms.TextMessage;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.util.resource.ILocatable;

public class DefaultMessageHandler
extends AbstractLocatableObject
implements IMessageHandler {
    private String name;
    private String procedure;
    private IObjectRegistry registry;
    private IProcedureManager procedureManager;
    private IServiceFactory serviceFactory;

    public DefaultMessageHandler(IObjectRegistry registry) {
        this.registry = registry;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void onMessage(Message message) {
        if (this.procedureManager == null) {
            this.procedureManager = (IProcedureManager)this.registry.getInstanceOfType(IProcedureManager.class);
            if (this.procedureManager == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IProcedureManager.class, (String)this.getClass().getName());
            }
            this.serviceFactory = (IServiceFactory)this.registry.getInstanceOfType(IServiceFactory.class);
            if (this.serviceFactory == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IServiceFactory.class, (String)this.getClass().getName());
            }
        }
        if (this.procedure == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"procedure");
        }
        ILogger logger = LoggingContext.getLogger((String)"aurora.plugin.jms", (IObjectRegistry)this.registry);
        if (message == null) {
            logger.log(Level.WARNING, "message is null");
            return;
        }
        if (message instanceof TextMessage) {
            CompositeMap context = new CompositeMap();
            try {
                try {
                    logger.log(Level.CONFIG, "receive message text:{0}", new Object[]{((TextMessage)message).getText()});
                    logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{this.procedure});
                    Procedure proc = null;
                    try {
                        proc = this.procedureManager.loadProcedure(this.procedure);
                    }
                    catch (Exception ex) {
                        throw BuiltinExceptionFactory.createResourceLoadException((ILocatable)this, (String)this.procedure, (Throwable)ex);
                    }
                    String name = "JMS." + this.procedure;
                    ServiceInvoker.invokeProcedureWithTransaction((String)name, (Procedure)proc, (IServiceFactory)this.serviceFactory, (CompositeMap)context);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Error when invoking procedure " + this.procedure, (Throwable)ex);
                    context.clear();
                }
            }
            finally {
                context.clear();
            }
        } else {
            logger.log(Level.CONFIG, "This is not TextMessage.This is " + message.getClass().getCanonicalName());
        }
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }
}

