/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.bill99.pos;

import aurora.plugin.bill99.Configuration;
import aurora.plugin.bill99.pos.MRefund;
import aurora.plugin.bill99.pos.SavingTrustManager;
import aurora.plugin.bill99.pos.SimpleXmlCreater;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Encoder;

public class RefundFunction {
    public static final String TITLE = "(\u76f4\u8fde)\u9000\u8d27\u4ea4\u6613";
    public static final String KEYSTORE_FILE = RefundFunction.getValue("pos_refund_keystore_file");
    public static final String ALGORITHM = "sunx509";
    public static final String PASSWORD = RefundFunction.getValue("pos_refund_password");

    private static String getValue(String key) {
        String value = Configuration.getInstance().getValue(key);
        return value == null ? "" : value;
    }

    public MRefund action(MRefund pf1, MRefund pf) {
        String str = this.getXml(pf1);
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(ALGORITHM);
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(this.getClass().getClassLoader().getResourceAsStream(KEYSTORE_FILE), PASSWORD.toCharArray());
            kmf.init(ks, PASSWORD.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(ALGORITHM);
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            SSLContext sslc = SSLContext.getInstance("SSL");
            sslc.init(kmf.getKeyManagers(), new TrustManager[]{tm}, new SecureRandom());
            SSLSocketFactory sf = sslc.getSocketFactory();
            String refundURL = RefundFunction.getValue("pos_refund_url");
            URL url = new URL(refundURL);
            BASE64Encoder en = new BASE64Encoder();
            String merchantId = RefundFunction.getValue("pos_refund_merchantId");
            String s = "Basic " + en.encode((String.valueOf(merchantId) + ":" + PASSWORD).getBytes());
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
            httpsURLConnection.setRequestProperty("Authorization", s);
            httpsURLConnection.setSSLSocketFactory(sf);
            RefundFunction.post(httpsURLConnection, str, pf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pf;
    }

    private String getXml(MRefund pf) {
        String xml = "";
        SimpleXmlCreater sxc = new SimpleXmlCreater();
        xml = String.valueOf(xml) + SimpleXmlCreater.xmlHead;
        xml = String.valueOf(xml) + SimpleXmlCreater.xmlHead2;
        xml = String.valueOf(xml) + sxc.addFullNode("version", pf.getVersion());
        xml = String.valueOf(xml) + sxc.addFatherNode("TxnMsgContent", false);
        xml = String.valueOf(xml) + sxc.addFullNode("txnType", pf.getTxnType());
        xml = String.valueOf(xml) + sxc.addFullNode("interactiveStatus", pf.getInteractiveStatus());
        xml = String.valueOf(xml) + sxc.addFullNode("orignalTxnType", pf.getOrignalTxnType());
        xml = String.valueOf(xml) + sxc.addFullNode("amount", pf.getAmount());
        xml = String.valueOf(xml) + sxc.addFullNode("merchantId", pf.getMerchantId());
        xml = String.valueOf(xml) + sxc.addFullNode("terminalId", pf.getTerminalId());
        xml = String.valueOf(xml) + sxc.addFullNode("entryTime", pf.getEntryTime());
        xml = String.valueOf(xml) + sxc.addFullNode("origRefNumber", pf.getOrigRefNumber());
        xml = String.valueOf(xml) + sxc.addFullNode("externalRefNumber", pf.getExternalRefNumber());
        xml = String.valueOf(xml) + sxc.addFatherNode("TxnMsgContent", true);
        xml = String.valueOf(xml) + SimpleXmlCreater.xmlEnd;
        return xml;
    }

    private static MRefund printXml(InputStream is, MRefund pf) {
        try {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                NodeList error = doc.getElementsByTagName("ErrorMsgContent");
                int i = 0;
                while (i < error.getLength()) {
                    pf.setErrorCode2(doc.getElementsByTagName("errorCode").item(i).getFirstChild().getNodeValue());
                    pf.setErrorMessage2(doc.getElementsByTagName("errorMessage").item(i).getFirstChild().getNodeValue());
                    ++i;
                }
                NodeList nl = doc.getElementsByTagName("TxnMsgContent");
                int i2 = 0;
                while (i2 < nl.getLength()) {
                    pf.setMerchantId2(doc.getElementsByTagName("merchantId").item(i2).getFirstChild().getNodeValue());
                    pf.setTxnType2(doc.getElementsByTagName("txnType").item(i2).getFirstChild().getNodeValue());
                    pf.setVersion2(doc.getElementsByTagName("version").item(i2).getFirstChild().getNodeValue());
                    pf.setRefNumber2(doc.getElementsByTagName("refNumber").item(i2).getFirstChild().getNodeValue());
                    pf.setInteractiveStatus2(doc.getElementsByTagName("interactiveStatus").item(i2).getFirstChild().getNodeValue());
                    pf.setAmount2(doc.getElementsByTagName("amount").item(i2).getFirstChild().getNodeValue());
                    pf.setTerminalId2(doc.getElementsByTagName("terminalId").item(i2).getFirstChild().getNodeValue());
                    pf.setEntryTime2(doc.getElementsByTagName("entryTime").item(i2).getFirstChild().getNodeValue());
                    pf.setExternalRefNumber2(doc.getElementsByTagName("externalRefNumber").item(i2).getFirstChild().getNodeValue());
                    pf.setTransTime2(doc.getElementsByTagName("transTime").item(i2).getFirstChild().getNodeValue());
                    pf.setResponseCode2(doc.getElementsByTagName("responseCode").item(i2).getFirstChild().getNodeValue());
                    ++i2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return pf;
    }

    public static void post(HttpsURLConnection httpsURLConnection, String str, MRefund pf) throws IOException {
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setRequestMethod("POST");
        httpsURLConnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
        httpsURLConnection.setRequestProperty("SOAPAction", " http://WebXml.com.cn/getWeatherbyCityName");
        httpsURLConnection.setRequestProperty("User-Agent", "Jakarta Commons-HttpClient/3.1");
        httpsURLConnection.setConnectTimeout(50000);
        httpsURLConnection.setReadTimeout(50000);
        httpsURLConnection.connect();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(httpsURLConnection.getOutputStream()));
        out.write(str);
        out.flush();
        out.close();
        pf = RefundFunction.printXml(httpsURLConnection.getInputStream(), pf);
        httpsURLConnection.disconnect();
    }
}

