/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util.template;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.util.template.IStaticContent;
import uncertain.util.template.ITagContent;

public class TextTemplate
implements Serializable,
Cloneable {
    LinkedList mContentList = new LinkedList();
    String mSourceName;

    public void setSourceName(String name) {
        this.mSourceName = name;
    }

    public String getSourceName() {
        return this.mSourceName;
    }

    public void addContent(IStaticContent content) {
        this.mContentList.add(content);
    }

    public void addContent(String content) {
        this.mContentList.add(content);
    }

    public void addContent(StringBuffer content) {
        this.mContentList.add(content);
    }

    public void addContent(ITagContent content) {
        this.mContentList.add(content);
    }

    public List getContents() {
        return null;
    }

    public void createOutput(Writer writer, CompositeMap context) throws IOException {
        for (Object obj : this.mContentList) {
            if (obj instanceof String || obj instanceof StringBuffer || obj instanceof StringBuilder) {
                writer.write(obj.toString());
                continue;
            }
            if (obj instanceof ITagContent) {
                String str = ((ITagContent)obj).getContent(context);
                if (str == null) continue;
                writer.write(str);
                continue;
            }
            if (!(obj instanceof IStaticContent)) continue;
            ((IStaticContent)obj).write(writer);
        }
    }

    public String toString(CompositeMap context) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        this.createOutput(writer, context);
        return baos.toString();
    }

    public void clear() {
        this.mContentList.clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        TextTemplate new_template = new TextTemplate();
        new_template.mSourceName = this.mSourceName;
        new_template.mContentList = new LinkedList();
        this.mContentList.addAll(this.mContentList);
        return new_template;
    }
}

