/*
 * Decompiled with CFR 0.152.
 */
package uncertain.schema;

import java.util.HashSet;
import java.util.Set;
import uncertain.ocm.IConfigureListener;
import uncertain.schema.ISchemaManager;
import uncertain.schema.ISchemaObject;
import uncertain.schema.Schema;

public abstract class AbstractSchemaObject
implements ISchemaObject,
IConfigureListener {
    ISchemaObject mParent;
    Set mChilds;

    public void setParent(ISchemaObject parent) {
        this.mParent = parent;
    }

    public ISchemaObject getParent() {
        return this.mParent;
    }

    public ISchemaManager getSchemaManager() {
        Schema schema = this.getSchema();
        return schema == null ? null : schema.getSchemaManager();
    }

    public Schema getSchema() {
        ISchemaObject o = this.mParent;
        while (o != null) {
            if (o instanceof Schema) {
                return (Schema)o;
            }
            o = o.getParent();
        }
        return null;
    }

    public void doAssemble() {
        if (this.mChilds != null) {
            for (ISchemaObject child : this.mChilds) {
                child.doAssemble();
            }
        }
    }

    public void validate() {
    }

    public void endConfigure() {
        this.validate();
    }

    public void addChild(ISchemaObject child) {
        if (this.mChilds == null) {
            this.mChilds = new HashSet();
        }
        child.setParent(this);
        this.mChilds.add(child);
    }

    public void addChilds(ISchemaObject[] childs) {
        int i = 0;
        while (i < childs.length) {
            this.addChild(childs[i]);
            ++i;
        }
    }

    public Set getChilds() {
        return this.mChilds;
    }
}

