/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import uncertain.composite.TextParser;
import uncertain.core.ConfigurationError;
import uncertain.proc.AbstractEntry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class Transfer
extends AbstractEntry {
    String mProcedure;
    IProcedureManager mProcedureManager;

    public Transfer(IProcedureManager procedureManager) {
        this.mProcedureManager = procedureManager;
    }

    public void run(ProcedureRunner runner) throws Exception {
        if (this.mProcedure == null) {
            throw new ConfigurationError("<call>: must set 'procedure' property");
        }
        String proc_name = TextParser.parse(this.mProcedure, runner.getContext());
        Procedure proc = this.mProcedureManager.loadProcedure(proc_name);
        if (proc == null) {
            throw new IllegalArgumentException("Can't load procedure " + proc_name);
        }
        runner.stop();
        runner.setProcedure(proc);
        runner.run();
    }

    public String getProcedure() {
        return this.mProcedure;
    }

    public void setProcedure(String procedure) {
        this.mProcedure = procedure;
    }
}

