/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.core.ConfigurationError;
import uncertain.core.IGlobalInstance;
import uncertain.proc.IProcedureManager;
import uncertain.proc.IProcedureRegistry;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureManager;

public class ProcedureRegistry
implements IProcedureRegistry,
IGlobalInstance {
    public static final String KEY_PROCEDURE_MAPPINGS = "procedure-mappings";
    public static final String KEY_PROCEDURES = "procedures";
    public static final QualifiedName PROCEDURE_NAME = new QualifiedName("uncertain.proc", "procedure");
    Map mProcedureNameMap = new HashMap();
    Map mProcedureConfigMap = new HashMap();
    IProcedureManager mProcedureManager;

    public ProcedureRegistry() {
        this.mProcedureManager = ProcedureManager.getDefaultInstance();
    }

    public ProcedureRegistry(IProcedureManager procedureManager) {
        this.mProcedureManager = procedureManager;
    }

    public String getMappedProcedure(String name) {
        return (String)this.mProcedureNameMap.get(name);
    }

    public CompositeMap getProcedureConfig(String name) {
        return (CompositeMap)this.mProcedureConfigMap.get(name);
    }

    public void addMappedProcedure(String name, String mapped_proc_name) {
        this.mProcedureNameMap.put(name, mapped_proc_name);
    }

    public void addProcedureConfig(String name, CompositeMap proc_config) {
        this.mProcedureConfigMap.put(name, proc_config);
    }

    public void addProcedures(CompositeMap proc_config) {
        Iterator it = proc_config.getChildIterator();
        if (it != null) {
            while (it.hasNext()) {
                CompositeMap item = (CompositeMap)it.next();
                if (!PROCEDURE_NAME.equals(item.getQName())) {
                    throw new ConfigurationError("not a valid procedure:" + item.toXML());
                }
                String name = item.getString("name");
                if (name == null) {
                    throw new ConfigurationError("no name defined in procedure:" + item.toXML());
                }
                this.addProcedureConfig(name, item);
            }
        }
    }

    public void addProcedureMappings(CompositeMap mappings) {
        Iterator it = mappings.getChildIterator();
        if (it != null) {
            while (it.hasNext()) {
                CompositeMap item = (CompositeMap)it.next();
                String name = item.getString("name");
                if (name == null) {
                    throw new ConfigurationError("'name' property must be set:" + item.toXML());
                }
                String procedure = item.getString("procedure");
                if (procedure == null) {
                    throw new ConfigurationError("'procedure' property must be set:" + item.toXML());
                }
                this.mProcedureNameMap.put(name, procedure);
            }
        }
    }

    public Procedure getProcedure(String name) {
        try {
            String proc_name = this.getMappedProcedure(name);
            if (proc_name != null) {
                return this.mProcedureManager.loadProcedure(proc_name);
            }
            CompositeMap config = this.getProcedureConfig(name);
            if (config != null) {
                return this.mProcedureManager.createProcedure(config);
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error when loading named procedure:" + name, ex);
        }
    }
}

