/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.util.Collection;
import java.util.Iterator;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.ConfigurationFileException;
import uncertain.ocm.OCManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class Loop
extends Procedure {
    public static final String KEY_PARENT_RECORD = "parent_record";
    String source;
    boolean nullable = true;

    public Loop() {
    }

    public Loop(OCManager om) {
        super(om);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        Object obj = null;
        obj = this.source != null ? context.getObject(TextParser.parse(this.source, context)) : context.getChilds();
        if (obj == null) {
            if (this.nullable) {
                return;
            }
            throw BuiltinExceptionFactory.createDataFromXPathIsNull(this, this.source);
        }
        Iterator source_it = null;
        if (obj instanceof CompositeMap) {
            source_it = ((CompositeMap)obj).getChildIterator();
        } else if (obj instanceof Collection) {
            source_it = ((Collection)obj).iterator();
        } else {
            String type = obj == null ? "(null)" : obj.getClass().getName();
            ConfigurationFileException ex = new ConfigurationFileException("uncertain.proc.loop_source_not_collection", new Object[]{this.source, type}, this);
            throw ex;
        }
        if (source_it != null) {
            CompositeMap old_context = runner.getContext();
            while (source_it.hasNext()) {
                CompositeMap item = (CompositeMap)source_it.next();
                if ("record".equals(context.getName())) {
                    item.put(KEY_PARENT_RECORD, context);
                }
                runner.setContext(item);
                super.run(runner);
                Throwable thr = runner.getException();
                if (thr != null) break;
            }
            runner.setContext(old_context);
        }
    }
}

