/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.util.HashMap;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.datatype.ConvertionException;
import uncertain.datatype.DataTypeRegistry;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.ConfigurationFileException;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;

public class Argument
extends AbstractLocatableObject {
    private String type;
    private String value;
    private String path;
    private Object objectValue;
    private Class classType;
    private static final Map primitiveClazz = new HashMap();
    private static final String INTEGER = "int";
    private static final String BYTE = "byte";
    private static final String CHARACTOR = "char";
    private static final String SHORT = "short";
    private static final String LONG = "long";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String BOOLEAN = "boolean";

    static {
        primitiveClazz.put(INTEGER, Integer.TYPE);
        primitiveClazz.put(BYTE, Byte.TYPE);
        primitiveClazz.put(CHARACTOR, Character.TYPE);
        primitiveClazz.put(SHORT, Short.TYPE);
        primitiveClazz.put(LONG, Long.TYPE);
        primitiveClazz.put(FLOAT, Float.TYPE);
        primitiveClazz.put(DOUBLE, Double.TYPE);
        primitiveClazz.put(BOOLEAN, Boolean.TYPE);
    }

    public void onInitialize(CompositeMap context, IObjectRegistry registry) {
        if (this.path == null && this.value == null) {
            throw BuiltinExceptionFactory.createOneAttributeMissing(this, "path,value");
        }
        if (this.path != null && this.value != null) {
            throw BuiltinExceptionFactory.createConflictAttributesExcepiton(this, "path,value");
        }
        this.objectValue = this.value;
        if (context != null) {
            this.type = TextParser.parse(this.type, context);
            this.objectValue = this.value != null ? TextParser.parse(this.value, context) : context.getObject(this.path);
        }
        try {
            this.classType = (Class)primitiveClazz.get(this.type);
            if (this.classType == null) {
                this.classType = Class.forName(this.type);
            }
            if (DataTypeRegistry.getInstance().getDataType(this.classType) != null) {
                this.objectValue = DataTypeRegistry.getInstance().convert(this.objectValue, this.classType);
            } else if ("instance".equals(this.path)) {
                this.objectValue = "uncertain.ocm.IObjectRegistry".equals(this.type) ? registry : registry.getInstanceOfType(this.classType);
            }
        }
        catch (ClassNotFoundException e) {
            throw BuiltinExceptionFactory.createClassNotFoundException(this, this.type);
        }
        catch (ConvertionException e) {
            throw new ConfigurationFileException("uncertain.exception.convertion_exception", new Object[]{this.objectValue, this.classType}, (Throwable)e, this);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void validConfig() {
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    public void setObjectValue(Object objectValue) {
        this.objectValue = objectValue;
    }

    public Class getClassType() {
        return this.classType;
    }

    public void setClassType(Class classType) {
        this.classType = classType;
    }
}

