/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.util.LinkedList;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.ConfigurationError;
import uncertain.logging.ILogger;
import uncertain.proc.AbstractEntry;
import uncertain.proc.Field;
import uncertain.proc.IEntry;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;
import uncertain.util.StringSplitter;

public class Action
extends AbstractEntry {
    String[] input_fields;
    String input;
    String[] output_fields;
    String output;
    boolean isNameDynamic = false;

    public void setName(String n) {
        super.setName(n);
        this.isNameDynamic = n.indexOf("${") >= 0;
    }

    private String[] split(String input) {
        String[] array = StringSplitter.splitToArray(input, ',', false);
        int i = 0;
        while (i < array.length) {
            array[i] = array[i].trim();
            ++i;
        }
        return array;
    }

    public void setInput(String input) {
        this.input = input;
        this.input_fields = this.split(input);
    }

    public String getInput() {
        return this.input;
    }

    public void setOutput(String output) {
        this.output = output;
        this.output_fields = this.split(output);
    }

    public String getOutput() {
        return this.output;
    }

    void getOutputFields(ProcedureRunner runner, Procedure proc) throws Exception {
        if (this.output_fields == null) {
            return;
        }
        LinkedList<Field> lst = new LinkedList<Field>();
        int i = 0;
        while (i < this.output_fields.length) {
            String name = this.output_fields[i];
            Field field = proc.getField(name);
            if (field == null) {
                throw new ConfigurationError("field " + name + " is not defined in root procedure");
            }
            lst.add(field);
            ++i;
        }
        runner.transferContextFields(lst, false);
    }

    Object[] getFieldValues(Procedure proc, CompositeMap context) {
        Object[] fields = null;
        if (this.input_fields != null) {
            fields = new Object[this.input_fields.length];
            int i = 0;
            while (i < this.input_fields.length) {
                Field fld = proc.getField(this.input_fields[i]);
                if (fld == null) {
                    throw new IllegalArgumentException("Field '" + this.input_fields[i] + "' is not defined in procedure");
                }
                fields[i] = context.getObject(fld.getPath());
                ++i;
            }
        }
        return fields;
    }

    public Procedure getParentProcedure() {
        IEntry owner = this.getOwner();
        while (owner != null) {
            if (owner instanceof Procedure) {
                return (Procedure)owner;
            }
            owner = owner.getOwner();
        }
        return null;
    }

    public void run(ProcedureRunner runner) throws Exception {
        Procedure proc = this.getParentProcedure();
        if (proc == null) {
            proc = (Procedure)runner.getProcedure().getRootOwner();
        }
        ILogger logger = runner.getLogger();
        CompositeMap context = runner.getContext();
        Object[] args = this.getFieldValues(proc, context);
        String event_name = this.isNameDynamic ? TextParser.parse(this.getName(), context) : this.getName();
        logger.log(Level.CONFIG, "[action] " + event_name);
        runner.fireEvent(event_name, args);
        this.getOutputFields(runner, proc);
    }
}

