/*
 * Decompiled with CFR 0.152.
 */
package uncertain.pkg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.composite.QualifiedName;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.MessageFactory;
import uncertain.ocm.ClassRegistry;
import uncertain.ocm.OCManager;
import uncertain.pkg.InstanceConfig;
import uncertain.pkg.PackageConfig;
import uncertain.pkg.PackageManager;
import uncertain.schema.ComplexType;
import uncertain.schema.IType;
import uncertain.schema.SchemaManager;

public class ComponentPackage {
    static final String CONFIG_PATH = "config";
    static final String CLASS_REGISTRY_FILE = "class-registry.xml";
    static final String PACKAGE_CONFIG_FILE = "package.xml";
    protected File mBasePathFile;
    protected File mConfigPathFile;
    protected String mBasePath;
    ClassRegistry mClassRegistry;
    String mVersion;
    String mDescription;
    String mName;
    PackageManager mOwner;
    SchemaManager mSchemaManager;
    InstanceConfig mInstanceConfig;
    CompositeMap mConfigData;
    PackageConfig mPackageConfig;
    Set mLoadedSchema = new HashSet();

    protected ComponentPackage() {
    }

    public void load(String path) throws IOException {
        this.setBasePath(path);
        this.initPackage();
    }

    public File getConfigPath() {
        return this.mConfigPathFile;
    }

    protected void loadSchemaFileByFullPath(String path) throws IOException {
        if (this.mLoadedSchema.contains(path)) {
            return;
        }
        try {
            this.mSchemaManager.loadSchemaByFile(path);
            this.mLoadedSchema.add(path);
        }
        catch (SAXException ex) {
            throw new IOException("Error in schema config file " + path + ":" + ex.getMessage());
        }
    }

    protected CompositeMap loadConfigFile(File config_path, String name, boolean is_required) {
        CompositeLoader loader = this.mOwner.getCompositeLoader();
        File config_file = new File(config_path, name);
        if (!config_file.exists()) {
            if (is_required) {
                throw BuiltinExceptionFactory.createRequiredFileNotFound(config_file.getAbsolutePath());
            }
            return null;
        }
        String path = config_file.getPath();
        return loader.silently().loadByFullFilePath(path);
    }

    protected void loadSchemaFile(File config_path) throws IOException {
        String[] schema_files;
        if (this.mPackageConfig != null && (schema_files = this.mPackageConfig.getSchemaFiles()) != null) {
            int i = 0;
            while (i < schema_files.length) {
                this.loadSchemaFileByFullPath(new File(config_path, schema_files[i]).getAbsolutePath());
                ++i;
            }
        }
        String extension = ".sxsd";
        File[] files = config_path.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            String file = files[i].getName().toLowerCase();
            if (file.endsWith(extension)) {
                try {
                    this.loadSchemaFileByFullPath(files[i].getAbsolutePath());
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error when parsing schema file " + files[i].getAbsolutePath(), ex);
                }
            }
            ++i;
        }
        Collection cl = this.mSchemaManager.getAllTypes();
        if (cl != null) {
            for (IType type : cl) {
                ComplexType complex_type;
                List lst;
                if (!(type instanceof ComplexType) || (lst = (complex_type = (ComplexType)type).getAllAttachedClasses()) == null || lst.size() <= 0) continue;
                QualifiedName qname = complex_type.getQName();
                Iterator tit = lst.iterator();
                while (tit.hasNext()) {
                    this.mClassRegistry.attachFeature(qname, (Class)tit.next());
                }
            }
        }
    }

    private void loadResources() {
        if (this.mPackageConfig == null) {
            return;
        }
        String[] resources = this.mPackageConfig.getResourceFiles();
        if (resources == null) {
            return;
        }
        int i = 0;
        while (i < resources.length) {
            MessageFactory.loadResource(resources[i], false);
            ++i;
        }
    }

    private Object createOptionalObject(String config_file, Class type) {
        File config_path = new File(this.mBasePathFile, CONFIG_PATH);
        OCManager oc_manager = this.mOwner.getOCManager();
        File source_file = new File(config_path, config_file);
        if (!source_file.exists()) {
            return null;
        }
        CompositeMap data = this.loadConfigFile(config_path, config_file, false);
        if (data != null) {
            Object inst = oc_manager.createObject(data);
            if (inst == null) {
                throw BuiltinExceptionFactory.createCannotCreateInstanceFromConfigException(null, source_file.getAbsolutePath());
            }
            if (!type.isInstance(inst)) {
                throw BuiltinExceptionFactory.createInstanceTypeWrongException(source_file.getAbsolutePath(), type, inst.getClass());
            }
            return inst;
        }
        return null;
    }

    protected void initPackage() throws IOException {
        OCManager oc_manager = this.mOwner.getOCManager();
        File config_path = new File(this.mBasePathFile, CONFIG_PATH);
        this.mConfigData = this.loadConfigFile(config_path, PACKAGE_CONFIG_FILE, false);
        if (this.mConfigData != null) {
            oc_manager.populateObject(this.mConfigData, this);
            this.mPackageConfig = (PackageConfig)DynamicObject.cast(this.mConfigData, PackageConfig.class);
        } else {
            this.setName(this.mBasePathFile.getName());
        }
        this.mClassRegistry = (ClassRegistry)this.createOptionalObject(CLASS_REGISTRY_FILE, ClassRegistry.class);
        this.mInstanceConfig = (InstanceConfig)this.createOptionalObject("instance.xml", InstanceConfig.class);
        if (this.mInstanceConfig != null) {
            this.mInstanceConfig.setOwnerPackage(this);
        }
        this.mSchemaManager = new SchemaManager(oc_manager);
        this.mSchemaManager.setParent(this.mOwner.getSchemaManager());
        this.loadSchemaFile(config_path);
        this.loadResources();
    }

    public String getName() {
        return this.mName;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getBasePath() {
        return this.mBasePath;
    }

    public void setBasePath(String basePath) throws FileNotFoundException {
        this.mBasePath = basePath;
        this.mBasePathFile = new File(this.mBasePath);
        if (!this.mBasePathFile.exists()) {
            throw new FileNotFoundException("Package base path " + basePath + " does not exist");
        }
        if (!this.mBasePathFile.isDirectory()) {
            throw new IllegalArgumentException("Path " + basePath + " is not a valid directory");
        }
        this.mConfigPathFile = new File(this.mBasePath, CONFIG_PATH);
    }

    public ClassRegistry getClassRegistry() {
        return this.mClassRegistry;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setPackageManager(PackageManager owner) {
        this.mOwner = owner;
    }

    public PackageManager getPackageManager() {
        return this.mOwner;
    }

    public SchemaManager getSchemaManager() {
        return this.mSchemaManager;
    }

    public InstanceConfig getInstanceConfig() {
        return this.mInstanceConfig;
    }

    public String toString() {
        return "package " + this.mName + " from " + this.mBasePathFile == null ? "(null)" : this.mBasePathFile.getAbsolutePath();
    }
}

