/*
 * Decompiled with CFR 0.152.
 */
package uncertain.ocm;

import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.ocm.MappingRule;
import uncertain.ocm.OCMEvent;

public class OCMEventFactory {
    public static final String OBJECT_MAPPED = "OBJECT_MAPPED";
    public static final String OBJECT_CREATED = "OBJECT_CREATED";
    public static final String MAPPING_RULE_LOADED = "MAPPING_RULE_LOADED";
    public static final String NAMESPACE_UNKNOWN = "NAMESPACE_UNKNOWN";
    public static final String OBJECT_CREATION_FAIL = "OBJECT_CREATION_FAIL";
    public static final String CANNOT_MAP_CLASS = "CANNOT_MAP_CLASS";
    public static final String CLASS_NOT_FOUND = "CLASS_NOT_FOUND";

    public static OCMEvent newNamespaceUnknownEvent(Object sender, String namespace) {
        OCMEvent event = new OCMEvent(NAMESPACE_UNKNOWN, sender, namespace);
        event.level = Level.WARNING.intValue();
        return event;
    }

    public static OCMEvent newObjectCreationFailEvent(Object sender, CompositeMap container) {
        OCMEvent event = new OCMEvent(OBJECT_CREATION_FAIL, sender, container);
        event.level = Level.SEVERE.intValue();
        return event;
    }

    public static OCMEvent newObjectMappedEvent(Object sender, Object mappedObject) {
        OCMEvent event = new OCMEvent(OBJECT_MAPPED, sender, mappedObject);
        event.level = Level.FINER.intValue();
        return event;
    }

    public static OCMEvent newObjectCreatedEvent(Object sender, Object obj) {
        OCMEvent event = new OCMEvent(OBJECT_CREATED, sender, obj);
        event.level = Level.FINER.intValue();
        return event;
    }

    public static OCMEvent newMappingRuleLoadedEvent(Object sender, MappingRule rule) {
        OCMEvent event = new OCMEvent(MAPPING_RULE_LOADED, sender, rule);
        return event;
    }

    public static OCMEvent newCannotMapClassEvent(Object sender, CompositeMap source) {
        OCMEvent event = new OCMEvent(CANNOT_MAP_CLASS, sender, source);
        event.level = Level.SEVERE.intValue();
        return event;
    }

    public static OCMEvent newClassNotFoundEvent(Object sender, String class_name) {
        OCMEvent event = new OCMEvent(CLASS_NOT_FOUND, sender, class_name);
        event.level = Level.SEVERE.intValue();
        return event;
    }
}

