/*
 * Decompiled with CFR 0.152.
 */
package uncertain.logging;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IConfigurable;

public class JDKFileHandler
extends Handler
implements IConfigurable {
    String pattern = null;
    int limit = 50000;
    int count = 1;
    boolean append = true;
    FileHandler mFileHandler;

    void createFileHandler() throws IOException {
        SimpleFormatter sfm = new SimpleFormatter();
        this.mFileHandler = new FileHandler(this.pattern, this.limit, this.count, this.append);
        this.mFileHandler.setFormatter(sfm);
    }

    public void beginConfigure(CompositeMap config) {
    }

    public void endConfigure() {
        try {
            this.createFileHandler();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create log file: " + this.pattern, ex);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void close() throws SecurityException {
        this.mFileHandler.close();
    }

    public void flush() {
        this.mFileHandler.flush();
    }

    public String getEncoding() {
        return this.mFileHandler.getEncoding();
    }

    public ErrorManager getErrorManager() {
        return this.mFileHandler.getErrorManager();
    }

    public Filter getFilter() {
        return this.mFileHandler.getFilter();
    }

    public Formatter getFormatter() {
        return this.mFileHandler.getFormatter();
    }

    public synchronized Level getLevel() {
        return this.mFileHandler.getLevel();
    }

    public boolean isLoggable(LogRecord record) {
        return this.mFileHandler.isLoggable(record);
    }

    public void publish(LogRecord record) {
        this.mFileHandler.publish(record);
    }

    protected void reportError(String msg, Exception ex, int code) {
        super.reportError(msg, ex, code);
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        this.mFileHandler.setEncoding(encoding);
    }

    public void setErrorManager(ErrorManager em) {
        this.mFileHandler.setErrorManager(em);
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        this.mFileHandler.setFilter(newFilter);
    }

    public void setFormatter(Formatter newFormatter) throws SecurityException {
        this.mFileHandler.setFormatter(newFormatter);
    }

    public synchronized void setLevel(Level newLevel) throws SecurityException {
        this.mFileHandler.setLevel(newLevel);
    }
}

