/*
 * Decompiled with CFR 0.152.
 */
package uncertain.exception;

import java.io.File;
import uncertain.composite.CompositeMap;
import uncertain.exception.ICodedException;
import uncertain.exception.MessageFactory;
import uncertain.proc.trace.IWithProcedureStackTrace;
import uncertain.proc.trace.TraceElement;
import uncertain.util.resource.ILocatable;
import uncertain.util.resource.Location;

public abstract class BaseRuntimeException
extends RuntimeException
implements ILocatable,
ICodedException,
IWithProcedureStackTrace {
    protected Location location;
    protected String sourceFile;
    protected String code;
    protected TraceElement traceElement;

    public BaseRuntimeException(String code, Object[] args, Throwable cause) {
        this(MessageFactory.getMessage(code, args), cause);
        this.setCode(code);
    }

    protected BaseRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    protected BaseRuntimeException(String message) {
        super(message);
    }

    protected BaseRuntimeException(Throwable cause) {
        super(cause);
    }

    public BaseRuntimeException(String code, Object[] args, Throwable cause, CompositeMap config) {
        this(MessageFactory.getMessage(code, args), cause);
        this.setCauseConfig(config);
        this.setCode(code);
    }

    public BaseRuntimeException(String code, Object[] args, Throwable cause, String source, Location location) {
        this(MessageFactory.getMessage(code, args), cause);
        this.setSource(source);
        this.setOriginLocation(location);
        this.setCode(code);
    }

    public BaseRuntimeException(String code, Object[] args, Throwable cause, ILocatable location) {
        this(code, args, cause, location == null ? null : location.getOriginSource(), location == null ? null : location.getOriginLocation());
    }

    public BaseRuntimeException(String code, Object[] args, ILocatable location) {
        this(code, args, null, location);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Location getOriginLocation() {
        return this.location;
    }

    public void setOriginLocation(Location location) {
        this.location = location;
    }

    public String getOriginSource() {
        return this.sourceFile;
    }

    public void setSource(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setCauseConfig(CompositeMap config) {
        this.location = config.getLocation();
        File file = config.getSourceFile();
        this.sourceFile = file == null ? null : file.getAbsolutePath();
    }

    public TraceElement getTraceElement() {
        return this.traceElement;
    }

    public void setTraceElement(TraceElement traceElement) {
        this.traceElement = traceElement;
    }

    public String getMessage() {
        String msg = super.getMessage();
        return MessageFactory.getExceptionMessage(this, msg);
    }
}

