/*
 * Decompiled with CFR 0.152.
 */
package uncertain.datatype;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import uncertain.datatype.AbstractDataType;
import uncertain.datatype.ConvertionException;
import uncertain.datatype.DataType;

public class FloatType
extends AbstractDataType
implements DataType {
    public Class getJavaType() {
        return Float.class;
    }

    public int getSqlType() {
        return 6;
    }

    public Object getObject(CallableStatement stmt, int id) throws SQLException {
        try {
            return this.convert(stmt.getObject(id));
        }
        catch (ConvertionException ex) {
            throw new SQLException("Error when converting data from Statement to Float for field No." + id);
        }
    }

    public Object getObject(ResultSet rs, int id) throws SQLException {
        try {
            return this.convert(rs.getObject(id));
        }
        catch (ConvertionException ex) {
            throw new SQLException("Error when converting data from ResultSet to Float for field No." + id);
        }
    }

    public void registerParameter(CallableStatement stmt, int id) throws SQLException {
        stmt.registerOutParameter(id, 6);
    }

    public void setParameter(PreparedStatement stmt, int id, Object value) throws SQLException {
        if (value == null) {
            stmt.setNull(id, this.getSqlType());
        } else {
            stmt.setFloat(id, ((Number)value).floatValue());
        }
    }

    public Object convert(Object value) throws ConvertionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return value;
        }
        if (value instanceof String) {
            if (((String)value).length() == 0) {
                return null;
            }
            try {
                return new Float((String)value);
            }
            catch (NumberFormatException ex) {
                throw new ConvertionException("Can't convert from string to float", ex);
            }
        }
        if (value instanceof Number) {
            return new Float(((Number)value).floatValue());
        }
        return null;
    }
}

