/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite;

import uncertain.composite.CompositeMap;
import uncertain.composite.ICompositeAccessor;
import uncertain.util.StringSplitHandle;
import uncertain.util.StringSplitter;

public class CompositeAccessor
implements ICompositeAccessor {
    static CompositeAccessor default_inst = new CompositeAccessor();
    char separator_char = (char)47;
    char attribute_char = (char)64;
    public static final char DEFAULT_SEPARATOR = '/';
    public static final char DEFAULT_ATTRIB_CHAR = '@';

    public static CompositeAccessor defaultInstance() {
        return default_inst;
    }

    public static CompositeMap putObject(CompositeMap map, String key, boolean is_attrib) {
        CompositeMap container = null;
        if (is_attrib) {
            container = new CompositeMap(key);
            map.put(key, container);
        } else {
            container = map.createChild(null, null, key);
        }
        return container;
    }

    KeySplitter SplitKey(CompositeMap map, String key, boolean create) {
        KeySplitter splitter = new KeySplitter(map, key, create);
        StringSplitter.split(key, 0, this.separator_char, true, splitter);
        return splitter;
    }

    public void put(CompositeMap map, String key, Object value) {
        this.put(map, key, value, true);
    }

    public boolean put(CompositeMap map, String key, Object value, boolean create) {
        if (key == null || map == null) {
            return false;
        }
        int last_id = key.lastIndexOf(this.separator_char);
        if (last_id < 0) {
            map.putObject(key, value, this.attribute_char);
            return true;
        }
        String prefix_key = key.substring(0, last_id);
        String last_key = key.substring(last_id + 1, key.length());
        KeySplitter splitter = this.SplitKey(map, prefix_key, create);
        CompositeMap root = splitter.getRoot();
        if (root == null) {
            return false;
        }
        return root.putObject(last_key, value, this.attribute_char) != null;
    }

    public Object get(CompositeMap map, String key) {
        if (key == null || map == null) {
            return null;
        }
        if (key.length() == 0) {
            return map.get(key);
        }
        int id = key.indexOf(this.separator_char);
        if (id == 0) {
            return this.get(map.getRoot(), key.substring(1));
        }
        if (id > 0) {
            KeySplitter splitter = this.SplitKey(map, key, false);
            if (!splitter.exists()) {
                return map.get(key);
            }
            return splitter.getValue();
        }
        return map.getObject(key, this.attribute_char);
    }

    public CompositeMap createChild(CompositeMap map, String key) {
        if (key == null || map == null) {
            return null;
        }
        if ("/".equals(key)) {
            return map.getRoot();
        }
        int id = key.indexOf(this.separator_char);
        if (id == 0) {
            return this.createChild(map.getRoot(), key.substring(1));
        }
        if (id > 0) {
            KeySplitter splitter = this.SplitKey(map, key, true);
            return (CompositeMap)splitter.getValue();
        }
        return map.createChild(null, null, key);
    }

    private class KeySplitter
    implements StringSplitHandle {
        public CompositeMap root;
        public Object container;
        public String key;
        public boolean create;
        int null_count = 0;
        boolean is_attrib = false;

        public void processString(String _key) {
            if (this.root == null) {
                ++this.null_count;
            }
            if (this.null_count > 1) {
                return;
            }
            if (_key == null) {
                return;
            }
            if (_key.length() == 0) {
                this.root = this.root.getRoot();
                return;
            }
            boolean bl = this.is_attrib = _key.charAt(0) == CompositeAccessor.this.attribute_char;
            if (this.is_attrib) {
                this.key = _key.substring(1);
                this.container = this.root.get(this.key);
            } else {
                this.key = _key;
                this.container = "..".equals(this.key) ? this.root.getParent() : this.root.getChild(this.key);
            }
            if (this.container != null && this.container instanceof CompositeMap) {
                this.root = (CompositeMap)this.container;
            } else if (this.create) {
                this.root = CompositeAccessor.putObject(this.root, this.key, this.is_attrib);
                this.container = this.root;
            } else {
                this.root = null;
                ++this.null_count;
            }
        }

        public KeySplitter(CompositeMap _root, String _key, boolean _create) {
            this.root = _root;
            this.key = _key;
            this.create = _create;
            this.container = this.root;
        }

        public boolean exists() {
            return this.null_count < 2;
        }

        public Object getValue() {
            return this.container;
        }

        public CompositeMap getRoot() {
            return this.root;
        }
    }
}

