/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.http;

import aurora.application.features.ServiceLogging;
import aurora.bm.BusinessModel;
import aurora.database.FetchDescriptor;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.service.http.FacadeServlet;
import aurora.service.http.HttpServiceFactory;
import aurora.service.http.HttpServiceInstance;
import aurora.service.http.WebContextInit;
import aurora.service.ws.BMWSDLGenerator;
import aurora.service.ws.ISOAPConfiguration;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uncertain.composite.CompositeMap;
import uncertain.composite.XMLOutputter;
import uncertain.core.UncertainEngine;
import uncertain.event.RuntimeContext;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class WSDLServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_NAME = "wsdl";
    private IObjectRegistry mRegistry;
    private DatabaseServiceFactory mDatabaseServiceFactory;
    private ISOAPConfiguration soapConfiguration;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        UncertainEngine uncertainEngine = WebContextInit.getUncertainEngine(context);
        if (uncertainEngine == null) {
            throw new ServletException("Uncertain engine not initialized");
        }
        this.mRegistry = uncertainEngine.getObjectRegistry();
        if (this.mRegistry == null) {
            throw new ServletException("IObjectRegistry not initialized");
        }
        this.mDatabaseServiceFactory = (DatabaseServiceFactory)this.mRegistry.getInstanceOfType(DatabaseServiceFactory.class);
        this.soapConfiguration = (ISOAPConfiguration)this.mRegistry.getInstanceOfType(ISOAPConfiguration.class);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String wsdl = "";
        CompositeMap dbConfig = null;
        ILogger appLogger = LoggingContext.getLogger(((Object)((Object)this)).getClass().getCanonicalName(), this.mRegistry);
        CompositeMap context = new CompositeMap("context");
        try {
            HttpServiceInstance svc = this.createServiceInstance(request, response);
            context = svc.getContextMap();
        }
        catch (Exception e) {
            appLogger.log(Level.SEVERE, "", e);
        }
        ILogger pageLogger = LoggingContext.getLogger(context, ((Object)((Object)this)).getClass().getCanonicalName());
        try {
            dbConfig = this.queryDBConfig(this.soapConfiguration, request, pageLogger);
        }
        catch (Exception e) {
            pageLogger.log(Level.SEVERE, "", e);
        }
        if (dbConfig != null && dbConfig.getChilds() != null) {
            CompositeMap record = (CompositeMap)dbConfig.getChilds().get(0);
            wsdl = record.getString(SERVLET_NAME);
        } else {
            boolean isBMRequest = this.isBMRequest(request);
            if (!isBMRequest) {
                wsdl = "<error>Svc'wsdl must define first!</error>";
            } else {
                String multi;
                BusinessModel bm;
                String uri = request.getRequestURI();
                String[] args = uri.split("/");
                if (args.length < 4) {
                    throw new ServletException("Invalid request format");
                }
                int start_index = 0;
                int i = 0;
                while (i < args.length) {
                    String tmp = args[i];
                    if (SERVLET_NAME.equals(tmp)) {
                        start_index = i;
                        break;
                    }
                    ++i;
                }
                String object_name = args[start_index + 1];
                String operation_name = null;
                if (start_index + 2 < args.length) {
                    operation_name = args[start_index + 2];
                }
                if ((bm = this.mDatabaseServiceFactory.getModelFactory().getModelForRead(object_name)) == null) {
                    throw new ServletException("Can't load model:" + object_name);
                }
                String fullUrl = this.getFullUrl(request);
                if (operation_name == null) {
                    throw new ServletException("pelease enter operation");
                }
                BMWSDLGenerator wsdlGenerator = "query".equalsIgnoreCase(operation_name) ? ("Y".equalsIgnoreCase(multi = request.getParameter("multi")) ? new BMWSDLGenerator(bm, fullUrl, true) : new BMWSDLGenerator(bm, fullUrl, false)) : new BMWSDLGenerator(bm, fullUrl, operation_name);
                wsdlGenerator.setDefaultResponse(this.soapConfiguration.getDefaultResponse());
                wsdl = XMLOutputter.defaultInstance().toXML(wsdlGenerator.run(), true);
            }
        }
        response.setContentType("text/plain;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.print(wsdl);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private String getFullUrl(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        if (request.getQueryString() != null) {
            url.append("?");
            url.append(request.getQueryString());
        }
        String request_url = url.toString();
        String autocrud = request_url.replace(SERVLET_NAME, "autocrud");
        return autocrud;
    }

    private CompositeMap queryDBConfig(ISOAPConfiguration soapConfiguration, HttpServletRequest request, ILogger appLogger) throws Exception {
        String model = soapConfiguration.getModel();
        if (model == null) {
            return null;
        }
        String url = WSDLServlet.getFullURL(request);
        appLogger.config("request Url:" + url);
        String accessUrl = "";
        boolean isBMRequest = this.isBMRequest(request);
        accessUrl = isBMRequest ? url.replace(SERVLET_NAME, "autocrud") : url.replace("wsdl/", "");
        appLogger.config("accessUrl :" + accessUrl);
        CompositeMap parameter = new CompositeMap("parameter");
        parameter.put("url", accessUrl);
        parameter.put("enabled_flag", "Y");
        return this.queryBM(model, parameter);
    }

    private static String getFullURL(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }

    private CompositeMap queryBM(String bm_name, CompositeMap parameter) throws Exception {
        IDatabaseServiceFactory databaseServiceFactory = (IDatabaseServiceFactory)this.mRegistry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (databaseServiceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IDatabaseServiceFactory.class, ((Object)((Object)this)).getClass().getName());
        }
        SqlServiceContext sqlContext = databaseServiceFactory.createContextWithConnection();
        try {
            CompositeMap resultMap;
            CompositeMap context = sqlContext.getObjectContext();
            if (context == null) {
                context = new CompositeMap();
            }
            BusinessModelService service = databaseServiceFactory.getModelService(bm_name, context);
            CompositeMap compositeMap = resultMap = service.queryAsMap(parameter, FetchDescriptor.fetchAll());
            return compositeMap;
        }
        finally {
            if (sqlContext != null) {
                sqlContext.freeConnection();
            }
        }
    }

    private boolean isBMRequest(HttpServletRequest request) {
        return !request.getRequestURI().endsWith(".svc");
    }

    private HttpServiceInstance createServiceInstance(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = FacadeServlet.getServiceName(request);
        HttpServiceFactory serviceFactory = (HttpServiceFactory)this.mRegistry.getInstanceOfType(HttpServiceFactory.class);
        if (serviceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, HttpServiceFactory.class, ((Object)((Object)this)).getClass().getName());
        }
        HttpServiceInstance svc = serviceFactory.createHttpService(name, request, response, this);
        ServiceLogging serviceLogging = (ServiceLogging)this.mRegistry.getInstanceOfType(ServiceLogging.class);
        if (serviceLogging == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, ServiceLogging.class, ((Object)((Object)this)).getClass().getName());
        }
        CompositeMap context = svc.getContextMap();
        serviceLogging.onContextCreate(RuntimeContext.getInstance(context));
        return svc;
    }
}

