/*
 * Decompiled with CFR 0.152.
 */
package aurora.security.crypto.encrypt;

import aurora.security.crypto.codec.Hex;
import aurora.security.crypto.codec.Utf8;
import aurora.security.crypto.encrypt.BytesEncryptor;
import aurora.security.crypto.encrypt.TextEncryptor;

final class HexEncodingTextEncryptor
implements TextEncryptor {
    private final BytesEncryptor encryptor;

    public HexEncodingTextEncryptor(BytesEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public String encrypt(String text) {
        return new String(Hex.encode(this.encryptor.encrypt(Utf8.encode(text))));
    }

    @Override
    public String decrypt(String encryptedText) {
        return Utf8.decode(this.encryptor.decrypt(Hex.decode(encryptedText)));
    }
}

