/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.BuildSession;
import aurora.presentation.component.std.config.FieldConfig;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class InputFieldConfig
extends FieldConfig {
    public static final String VERSION = "$Revision: 8395 $";
    public static final String PROPERTITY_EMPTYTEXT = "emptytext";
    public static final String PROPERTITY_INPUTWIDTH = "inputwidth";
    public static final String PROPERTITY_EDITABLE = "editable";
    public static final String PROPERTITY_MAX_LENGHT = "maxlength";
    public static final String PROPERTITY_CHARA_TRANSFORM = "transformcharacter";
    public static final String PROPERTITY_AUTO_SELECT = "autoselect";
    public static final String PROPERTITY_FONT_STYLE = "fontstyle";
    private int DEFAULT_INPUT_WIDTH = 100;

    public String getEmptyText() {
        return this.getString(PROPERTITY_EMPTYTEXT, "");
    }

    public String getEmptyText(BuildSession session, CompositeMap model) {
        return session.getLocalizedPrompt(TextParser.parse(this.getString(PROPERTITY_EMPTYTEXT, ""), model));
    }

    public void setEmptyText(String text) {
        this.putString(PROPERTITY_EMPTYTEXT, text);
    }

    public int getInputWidth() {
        return this.getInt(PROPERTITY_INPUTWIDTH, this.DEFAULT_INPUT_WIDTH);
    }

    public void setInputWidth(int width) {
        this.putInt(PROPERTITY_INPUTWIDTH, width);
    }

    public boolean isEditable() {
        return this.getBoolean(PROPERTITY_EDITABLE, true);
    }

    public void setEditable(boolean editable) {
        this.put(PROPERTITY_EDITABLE, editable);
    }

    public Integer getMaxLength() {
        return this.getInteger(PROPERTITY_MAX_LENGHT);
    }

    public void setMaxLength(Integer ml) {
        this.putInt(PROPERTITY_MAX_LENGHT, ml);
    }

    public boolean isTransformCharacter() {
        return this.getBoolean(PROPERTITY_CHARA_TRANSFORM, true);
    }

    public void setTransformCharacter(boolean tc) {
        this.putBoolean(PROPERTITY_CHARA_TRANSFORM, tc);
    }

    public boolean isAutoSelect() {
        return this.getBoolean(PROPERTITY_AUTO_SELECT, true);
    }

    public void setAutoSelect(boolean as) {
        this.putBoolean(PROPERTITY_AUTO_SELECT, as);
    }

    public String getFontStyle(CompositeMap model) {
        return TextParser.parse(this.getString(PROPERTITY_FONT_STYLE), model);
    }

    public void setFontStyle(String fontStyle) {
        this.putString(PROPERTITY_FONT_STYLE, fontStyle);
    }
}

