/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.component.std.config.BoxConfig;
import aurora.presentation.component.std.config.ComponentConfig;
import aurora.presentation.component.std.config.GridColumnConfig;
import uncertain.composite.CompositeMap;

public class GridBoxConfig
extends BoxConfig {
    public static final String VERSION = "$Revision: 8425 $";
    public static final String TAG_NAME = "gridBox";
    public static final String PROPERTITY_COLUMNS = "columns";
    public static final String PROPERTITY_EDITOR = "editor";
    public static final String PROPERTITY_EDITORS = "editors";
    public static final String PROPERTITY_UNDERBOX = "underbox";

    public static GridBoxConfig getInstance() {
        GridBoxConfig model = new GridBoxConfig();
        model.initialize(GridBoxConfig.createContext(null, TAG_NAME));
        return model;
    }

    public static GridBoxConfig getInstance(CompositeMap context) {
        GridBoxConfig model = new GridBoxConfig();
        model.initialize(GridBoxConfig.createContext(context, TAG_NAME));
        return model;
    }

    public CompositeMap getColumns() {
        CompositeMap context = this.getObjectContext();
        CompositeMap columns = context.getChild(PROPERTITY_COLUMNS);
        if (columns == null) {
            columns = new CompositeMap(PROPERTITY_COLUMNS);
            context.addChild(columns);
        }
        return columns;
    }

    public void addColumn(GridColumnConfig column) {
        CompositeMap columns = this.getColumns();
        columns.addChild(column.getObjectContext());
    }

    public CompositeMap getEditors() {
        CompositeMap context = this.getObjectContext();
        CompositeMap editors = context.getChild(PROPERTITY_EDITORS);
        if (editors == null) {
            editors = new CompositeMap(PROPERTITY_EDITORS);
            context.addChild(editors);
        }
        return editors;
    }

    public void addEditor(ComponentConfig editor) {
        CompositeMap editors = this.getEditors();
        editors.addChild(editor.getObjectContext());
    }

    public boolean getUnderBox() {
        return this.getBoolean(PROPERTITY_UNDERBOX, false);
    }

    public void setUnderBox(boolean underBox) {
        this.putBoolean(PROPERTITY_UNDERBOX, underBox);
    }

    public Integer getColumn() {
        Integer cols = this.getInteger("column");
        if (cols == null) {
            cols = new Integer(this.getColumns().getChilds().size());
        }
        return cols;
    }

    @Override
    public void setColumn(int column) {
        this.putInt("column", column);
    }
}

