/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.config.TabConfig;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class Tab
extends Component {
    public static final String VERSION = "$Revision: 8432 $";
    private static final String DEFAULT_CLASS = "item-tab";
    private static final String VALID_SCRIPT = "validscript";
    private static final String TABS = "tabs";

    public Tab(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "tab/Tab-min.css");
        this.addJavaScript(session, context, "tab/Tab-min.js");
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        StringBuffer sb = new StringBuffer();
        Integer bodyWidth = new Integer((Integer)map.get("width") - 2);
        Integer bodyHeight = new Integer((Integer)map.get("height") - 25);
        map.put("bodywidth", bodyWidth);
        map.put("headwidth", new Integer(bodyWidth - 36));
        map.put("bodyheight", bodyHeight);
        map.put("strips", this.createTabStrips(session, context, sb));
        map.put("bodys", this.createTabBodys(session, context));
        if ((Integer)map.get("stripswidth") <= bodyWidth - 36) {
            map.put("display", "none");
        }
        map.put(VALID_SCRIPT, sb.toString());
        map.put("config", this.getConfigString());
    }

    private String createTabBodys(BuildSession session, ViewContext context) throws IOException {
        List childs;
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        Map map = context.getMap();
        StringBuffer sb = new StringBuffer();
        CompositeMap tabs = view.getChild(TABS);
        if (tabs != null && (childs = tabs.getChilds()) != null) {
            for (CompositeMap tab : childs) {
                if (this.isHidden(tab, model)) continue;
                TabConfig tc = TabConfig.getInstance(tab);
                Integer bodywidth = (Integer)map.get("bodywidth");
                Integer bodyheight = (Integer)map.get("bodyheight");
                String ref = tc.getRef();
                String bodyClass = tc.getBodyClass();
                String bodyStyle = tc.getBodyStyle();
                sb.append("<div class='tab " + bodyClass + "' hideFocus tabIndex='-1' style='width:" + bodywidth + "px;height:" + bodyheight + "px;" + bodyStyle + "'");
                if ("".equals(ref)) {
                    String hostid = IDGenerator.getInstance().generate();
                    sb.append(" host_id='" + hostid + "'>");
                    List tabchilds = tab.getChilds();
                    if (tabchilds != null) {
                        for (CompositeMap tabchild : tabchilds) {
                            tabchild.putString("hostid", hostid);
                            try {
                                sb.append(session.buildViewAsString(model, tabchild));
                            }
                            catch (Exception e) {
                                throw new IOException(e);
                            }
                        }
                    }
                } else {
                    sb.append(">");
                }
                sb.append("</div>");
            }
        }
        return sb.toString();
    }

    private String createTabStrips(BuildSession session, ViewContext context, StringBuffer st) {
        List childs;
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        JSONArray jsons = new JSONArray();
        StringBuffer sb = new StringBuffer();
        CompositeMap tabs = view.getChild(TABS);
        int stripswidth = 0;
        if (tabs != null && (childs = tabs.getChilds()) != null) {
            Iterator it = childs.iterator();
            int i = 0;
            while (it.hasNext()) {
                CompositeMap tab = (CompositeMap)it.next();
                if (this.isHidden(tab, model)) continue;
                TabConfig tc = TabConfig.getInstance(tab);
                String prompt = session.getLocalizedPrompt(tc.getPrompt());
                int width = tc.getWidth(60);
                stripswidth += width + 6;
                String id = tc.getId("");
                String target = tc.getBindTarget();
                if (!"".equals(target)) {
                    if ("".equals(id)) {
                        id = IDGenerator.getInstance().generate();
                    }
                    String[] ts = target.split(",");
                    int b = 0;
                    while (b < ts.length) {
                        String tid = ts[b];
                        st.append("$('" + tid + "').on('valid',function(ds, record, name, valid){if(!valid && !Ext.get('" + id + "').hasActiveFx()) Ext.get('" + id + "').frame('ff0000', 3, { duration: 1 })});\n");
                        ++b;
                    }
                }
                String tabClass = tc.getTabClass();
                String tabStyle = tc.getTabStyle();
                boolean closeable = tc.isCloseable();
                boolean disabled = tc.isDisabled();
                boolean selected = tc.isSelected();
                if (selected) {
                    map.put("selected", new Integer(i));
                    this.addConfig("selected", new Integer(i));
                }
                if (!"".equals(tabStyle)) {
                    tabStyle = "style='" + tabStyle + "'";
                }
                sb.append("<div class='strip unactive");
                if (disabled) {
                    sb.append(" scroll-disabled");
                }
                sb.append("' " + tabStyle + " unselectable='on' " + (!"".equals(id) ? "id='" + id + "'" : "") + " onselectstart='return false;'><div style='height:26px;width:" + (width + 6) + "px'>");
                sb.append("<div class='strip-left " + tabClass + "'></div>");
                sb.append("<div class='strip-center " + tabClass + "' style='width:" + width + "px;'>");
                if (closeable) {
                    sb.append("<div class='tab-close'></div>");
                }
                sb.append(String.valueOf(prompt) + "</div>");
                sb.append("<div class='strip-right " + tabClass + "'></div>");
                sb.append("</div></div>");
                tab.putBoolean("selected", selected);
                String ref = TextParser.parse(tc.getRef(), model);
                tab.putString("ref", ref);
                JSONObject json = new JSONObject(tab);
                jsons.put(json);
                ++i;
            }
        }
        map.put("stripswidth", new Integer(stripswidth));
        this.addConfig("items", jsons);
        map.put("items", jsons.toString());
        return sb.toString();
    }
}

