/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class OfficeEditor
extends Component {
    public static final String VERSION = "$Revision$";

    public OfficeEditor(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addJavaScript(session, context, "office/OfficeEditor.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        String sourcetype;
        String pkvalue;
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        CompositeMap view = context.getView();
        String docUrl = view.getString("docurl", "");
        if (docUrl != null) {
            docUrl = TextParser.parse(docUrl, model);
        }
        this.addConfig("docUrl", docUrl);
        this.addConfig("docType", view.getString("doctype"));
        this.addConfig("readOnly", view.getBoolean("readonly", true));
        String saveUrl = view.getString("saveurl");
        if (saveUrl != null) {
            this.addConfig("saveUrl", TextParser.parse(saveUrl, model));
        }
        if ((pkvalue = view.getString("pkvalue")) != null) {
            this.addConfig("pkvalue", TextParser.parse(pkvalue, model));
        }
        if ((sourcetype = view.getString("sourcetype")) != null) {
            this.addConfig("sourcetype", TextParser.parse(sourcetype, model));
        }
        String context_path = model.getObject("/request/@context_path").toString();
        map.put("context_path", context_path);
        map.put("config", this.getConfigString());
    }
}

